/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public final class FixedBitSetCachingWrapperFilter
extends CachingWrapperFilter {
    public FixedBitSetCachingWrapperFilter(Filter filter) {
        super(filter);
    }

    protected DocIdSet docIdSetToCache(DocIdSet docIdSet, AtomicReader reader) throws IOException {
        if (docIdSet == null) {
            return DocIdSet.EMPTY;
        }
        if (docIdSet instanceof FixedBitSet) {
            return docIdSet;
        }
        DocIdSetIterator it = docIdSet.iterator();
        if (it == null) {
            return DocIdSet.EMPTY;
        }
        FixedBitSet copy = new FixedBitSet(reader.maxDoc());
        copy.or(it);
        return copy;
    }
}

