/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.state;

import de.saly.elasticsearch.importer.imap.state.State;
import de.saly.elasticsearch.importer.imap.state.StateManager;
import java.io.IOException;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.TimeValue;

public class ElasticsearchStateManager
implements StateManager {
    private static final String ERRORS_ID = "errors";
    private static final String FOLDERSTATE_ID = "folderstate";
    private static final String RIVERSTATE_TYPE = "imapriverstate";
    private Client client;
    private String index;
    private final ObjectMapper mapper = new ObjectMapper();
    protected final ESLogger logger = ESLoggerFactory.getLogger((String)this.getClass().getName());

    public ElasticsearchStateManager client(Client client) {
        this.client = client;
        return this;
    }

    @Override
    public synchronized State getRiverState(Folder folder) throws MessagingException {
        try {
            GetResponse response;
            this.waitForCluster();
            if (((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.index()}).execute().actionGet()).isExists() && !(response = (GetResponse)this.client.prepareGet(this.index(), RIVERSTATE_TYPE, "folderstate_" + folder.getURLName().toString().hashCode()).execute().get()).isSourceEmpty()) {
                return (State)this.mapper.readValue(response.getSourceAsString(), (TypeReference)new TypeReference<State>(){});
            }
        }
        catch (Exception ex) {
            throw new MessagingException("Unable to get river state", ex);
        }
        State rs = new State();
        rs.setFolderUrl(folder.getURLName().toString());
        rs.setExists(true);
        return rs;
    }

    public String index() {
        return this.index;
    }

    public ElasticsearchStateManager index(String index) {
        this.index = index;
        return this;
    }

    @Override
    public void onError(String errmsg, Folder folder, Exception e) {
        this.logger.error("Folder " + folder.getFullName() + " throws an error:" + errmsg + e, (Throwable)e, new Object[0]);
        try {
            this.client.prepareIndex(this.index(), RIVERSTATE_TYPE, "errors_" + folder.getURLName().toString().hashCode()).setSource(this.mapper.writeValueAsString((Object)new IndexableError(null, folder.getURLName().toString(), errmsg + e))).execute().actionGet();
        }
        catch (Exception ex) {
            this.logger.error("Unable to log an error because of " + ex + errmsg, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void onError(String errmsg, Message msg, Exception e) {
        try {
            this.logger.error("Message " + ((MimeMessage)msg).getMessageID() + " throws an error: " + errmsg + e, (Throwable)e, new Object[0]);
            this.client.prepareIndex(this.index(), RIVERSTATE_TYPE, "errors_" + ((MimeMessage)msg).getMessageID().hashCode()).setSource(this.mapper.writeValueAsString((Object)new IndexableError(((MimeMessage)msg).getMessageID(), null, errmsg + e))).execute().actionGet();
        }
        catch (Exception ex) {
            this.logger.error("Unable to log an error because of " + ex + errmsg, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setRiverState(State state) throws MessagingException {
        try {
            this.logger.debug("set riverstate " + state, new Object[0]);
            this.client.prepareIndex(this.index(), RIVERSTATE_TYPE, "folderstate_" + state.getFolderUrl().hashCode()).setSource(this.mapper.writeValueAsString((Object)state)).execute().actionGet();
            this.logger.debug("set riverstate done", new Object[0]);
        }
        catch (Exception ex) {
            throw new MessagingException("Unable to set river state", ex);
        }
    }

    private void waitForCluster() throws IOException {
        this.waitForCluster(ClusterHealthStatus.YELLOW, TimeValue.timeValueSeconds((long)30L));
    }

    private void waitForCluster(ClusterHealthStatus status, TimeValue timeout) throws IOException {
        try {
            this.logger.debug("waiting for cluster state {}", new Object[]{status.name()});
            ClusterHealthResponse healthResponse = (ClusterHealthResponse)this.client.admin().cluster().prepareHealth(new String[0]).setWaitForStatus(status).setTimeout(timeout).execute().actionGet();
            if (healthResponse.isTimedOut()) {
                throw new IOException("cluster state is " + healthResponse.getStatus().name() + " and not " + status.name() + ", cowardly refusing to continue with operations");
            }
            this.logger.debug("... cluster state ok", new Object[0]);
        }
        catch (ElasticsearchTimeoutException e) {
            throw new IOException("timeout, cluster does not respond to health request, cowardly refusing to continue with operations");
        }
    }

    private static class IndexableError {
        private final String errormsg;
        private final String folderurl;
        private final String messageid;

        public IndexableError(String messageid, String folderurl, String errormsg) {
            this.messageid = messageid;
            this.folderurl = folderurl;
            this.errormsg = errormsg;
        }

        public String getErrormsg() {
            return this.errormsg;
        }

        public String getFolderurl() {
            return this.folderurl;
        }

        public String getMessageid() {
            return this.messageid;
        }
    }
}

