/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.ldap;

import de.saly.elasticsearch.importer.imap.ldap.ILdapConnector;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;

public class SimpleLdapConnector
implements ILdapConnector {
    private final String fUrl;
    private final String fUser;
    private final String fUserContext;
    private final char[] fPassword;
    private final SearchControls fCtrl;
    private final boolean fReadOnly;
    private DirContext fContext;
    private boolean fConnected;

    public SimpleLdapConnector(String url, String context, String user, String password, boolean readOnly) {
        this.fUrl = url;
        if (this.fUrl == null || this.fUrl.isEmpty()) {
            throw new NullPointerException("no URL given");
        }
        this.fUserContext = context == null ? "" : "," + context;
        this.fUser = user;
        this.fPassword = password.toCharArray();
        this.fReadOnly = readOnly;
        this.fCtrl = new SearchControls();
        this.fCtrl.setSearchScope(2);
    }

    @Override
    public void connect() throws Exception {
        if (!this.fConnected) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.fUrl);
            if (this.fUser != null && this.fPassword != null) {
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", this.fUser);
                env.put("java.naming.security.credentials", new String(this.fPassword));
            }
            this.fContext = new InitialDirContext(env);
            this.fConnected = true;
        }
    }

    @Override
    public void disconnect() throws Exception {
        if (this.fConnected) {
            this.fConnected = false;
            this.fContext.close();
        }
    }

    @Override
    public boolean isConnected() {
        return this.fConnected;
    }

    @Override
    public NamingEnumeration nameQuery(String name) throws Exception {
        return this.query(name, "uid=*");
    }

    @Override
    public NamingEnumeration filterQuery(String filter) throws Exception {
        return this.query("", filter);
    }

    @Override
    public NamingEnumeration query(String name, String filter) throws Exception {
        name = !name.isEmpty() ? "uid=" + name + this.fUserContext : this.fUserContext.substring(1);
        return this.fContext.search(name, filter, this.fCtrl);
    }

    @Override
    public void update(String name, ModificationItem[] mods) throws Exception {
        if (!this.fReadOnly && !name.isEmpty()) {
            name = "uid=" + name + this.fUserContext;
            this.fContext.modifyAttributes(name, mods);
        }
    }

    @Override
    public void create(String name, DirContext object) throws Exception {
        if (!this.fReadOnly) {
            if (!name.isEmpty()) {
                name = "uid=" + name + this.fUserContext;
            }
            this.fContext.bind(name, (Object)object);
        }
    }

    @Override
    public void remove(String name) throws Exception {
        if (!name.isEmpty()) {
            name = "uid=" + name + this.fUserContext;
        }
        this.fContext.destroySubcontext(name);
    }
}

