/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.impl;

import de.saly.elasticsearch.importer.imap.ldap.LdapLoginSource;
import de.saly.elasticsearch.importer.imap.maildestination.ElasticsearchBulkMailDestination;
import de.saly.elasticsearch.importer.imap.maildestination.MailDestination;
import de.saly.elasticsearch.importer.imap.mailsource.MailSource;
import de.saly.elasticsearch.importer.imap.mailsource.ParallelPollingIMAPMailSource;
import de.saly.elasticsearch.importer.imap.mailsource.ParallelPollingPOPMailSource;
import de.saly.elasticsearch.importer.imap.state.ElasticsearchStateManager;
import de.saly.elasticsearch.importer.imap.support.MailFlowJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class IMAPImporter {
    private volatile boolean closed;
    private final String folderPattern;
    private final String indexName;
    private final String indexNameStrategy;
    private final TimeValue interval;
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)IMAPImporter.class.getName());
    private final List<MailSource> mailSources = new ArrayList<MailSource>();
    private final List<String> passwords = new ArrayList<String>();
    private final Properties props = new Properties();
    private final Client client;
    private Scheduler sched;
    private final String schedule;
    private final String typeName;
    private final List<String> indices = new ArrayList<String>();
    private final List<String> users = new ArrayList<String>();
    private final List<String> headersToFields;

    public IMAPImporter(Map<String, Object> imapSettings, Client client) {
        this.client = client;
        this.getUserLogins(imapSettings);
        this.folderPattern = XContentMapValues.nodeStringValue((Object)imapSettings.get("folderpattern"), null);
        this.indexName = XContentMapValues.nodeStringValue((Object)imapSettings.get("mail_index_name"), (String)"imapriverdata");
        this.indexNameStrategy = XContentMapValues.nodeStringValue((Object)imapSettings.get("mail_index_name_strategy"), (String)"all_in_one");
        this.typeName = XContentMapValues.nodeStringValue((Object)imapSettings.get("mail_type_name"), (String)"mail");
        this.schedule = imapSettings.containsKey("schedule") ? XContentMapValues.nodeStringValue((Object)imapSettings.get("schedule"), null) : null;
        this.interval = XContentMapValues.nodeTimeValue((Object)imapSettings.get("interval"), (TimeValue)TimeValue.timeValueMinutes((long)1L));
        this.headersToFields = this.arrayNodeToList(imapSettings.get("headers_to_fields"));
        int bulkSize = XContentMapValues.nodeIntegerValue((Object)imapSettings.get("bulk_size"), (int)100);
        int maxBulkRequests = XContentMapValues.nodeIntegerValue((Object)imapSettings.get("max_bulk_requests"), (int)30);
        TimeValue flushInterval = XContentMapValues.nodeTimeValue((Object)imapSettings.get("bulk_flush_interval"), (TimeValue)TimeValue.timeValueSeconds((long)5L));
        int threads = XContentMapValues.nodeIntegerValue((Object)imapSettings.get("threads"), (int)5);
        boolean withTextContent = XContentMapValues.nodeBooleanValue((Object)imapSettings.get("with_text_content"), (boolean)true);
        boolean withHtmlContent = XContentMapValues.nodeBooleanValue((Object)imapSettings.get("with_html_content"), (boolean)false);
        boolean preferHtmlContent = XContentMapValues.nodeBooleanValue((Object)imapSettings.get("prefer_html_content"), (boolean)false);
        boolean withFlagSync = XContentMapValues.nodeBooleanValue((Object)imapSettings.get("with_flag_sync"), (boolean)true);
        boolean withAttachments = XContentMapValues.nodeBooleanValue((Object)imapSettings.get("with_attachments"), (boolean)false);
        boolean stripTagsFromTextContent = XContentMapValues.nodeBooleanValue((Object)imapSettings.get("with_striptags_from_textcontent"), (boolean)true);
        boolean keepExpungedMessages = XContentMapValues.nodeBooleanValue((Object)imapSettings.get("keep_expunged_messages"), (boolean)false);
        Map indexSettings = imapSettings.get("index_settings") != null ? XContentMapValues.nodeMapValue((Object)imapSettings.get("index_settings"), null) : null;
        Map typeMapping = imapSettings.get("type_mapping") != null ? XContentMapValues.nodeMapValue((Object)imapSettings.get("type_mapping"), null) : null;
        for (Map.Entry<String, Object> entry : imapSettings.entrySet()) {
            if (entry == null || !entry.getKey().startsWith("mail.")) continue;
            this.props.setProperty(entry.getKey(), String.valueOf(entry.getValue()));
        }
        if (StringUtils.isEmpty((String)this.props.getProperty("mail.store.protocol"))) {
            logger.warn("mail.store.protocol not set, assume its 'imaps'", new Object[0]);
            this.props.setProperty("mail.store.protocol", "imaps");
        }
        logger.debug("river settings " + imapSettings, new Object[0]);
        logger.debug("mail settings " + this.props, new Object[0]);
        for (int i = 0; i < this.users.size(); ++i) {
            String user = this.users.get(i);
            String password = this.passwords.get(i);
            String _indexName = null;
            if ("all_in_one".equalsIgnoreCase(this.indexNameStrategy)) {
                _indexName = this.indexName;
            } else if ("username".equalsIgnoreCase(this.indexNameStrategy)) {
                _indexName = user;
            } else if ("username_crop".equalsIgnoreCase(this.indexNameStrategy)) {
                _indexName = user.split("@")[0];
            } else if ("prefixed_username".equalsIgnoreCase(this.indexNameStrategy)) {
                _indexName = this.indexName + "-" + user;
            } else if ("prefixed_username_crop".equalsIgnoreCase(this.indexNameStrategy)) {
                _indexName = this.indexName + "-" + user.split("@")[0];
            }
            ElasticsearchStateManager riverStateManager = new ElasticsearchStateManager().client(client).index(_indexName);
            MailSource mailSource = null;
            MailDestination mailDestination = new ElasticsearchBulkMailDestination().maxBulkActions(bulkSize).maxConcurrentBulkRequests(maxBulkRequests).flushInterval(flushInterval).client(client).setMapping(typeMapping).setSettings(indexSettings).setType(this.typeName).setIndex(_indexName).setWithAttachments(withAttachments).setWithTextContent(withTextContent).setWithHtmlContent(withHtmlContent).setPreferHtmlContent(preferHtmlContent).setStripTagsFromTextContent(stripTagsFromTextContent).setHeadersToFields(this.headersToFields);
            mailSource = this.props.getProperty("mail.store.protocol").toLowerCase().contains("imap") ? new ParallelPollingIMAPMailSource(this.props, threads, user, password).setWithFlagSync(withFlagSync) : new ParallelPollingPOPMailSource(this.props, threads, user, password);
            mailSource.setDeleteExpungedMessages(!keepExpungedMessages);
            mailSource.setMailDestination(mailDestination);
            mailSource.setStateManager(riverStateManager);
            this.mailSources.add(mailSource);
            this.indices.add(_indexName);
        }
        logger.info("IMAPRiver created", new Object[0]);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        logger.info("Closing IMAPRiver ...", new Object[0]);
        this.closed = true;
        try {
            if (this.sched != null && this.sched.isStarted()) {
                this.sched.shutdown();
                logger.info("Scheduler shutted down", new Object[0]);
            }
        }
        catch (SchedulerException e) {
            logger.warn("Unable to shutdown scheduler due to " + (Object)((Object)e), (Throwable)e, new Object[0]);
        }
        for (int i = 0; i < this.mailSources.size(); ++i) {
            MailSource mailSource = this.mailSources.get(i);
            mailSource.getMailDestination().close();
            mailSource.close();
        }
        logger.info("IMAPRiver closed", new Object[0]);
    }

    public List<String> getIndexNames() {
        return Collections.unmodifiableList(this.indices);
    }

    public String getIndexNameStrategy() {
        return this.indexNameStrategy;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void once() throws MessagingException, IOException {
        for (int i = 0; i < this.mailSources.size(); ++i) {
            MailSource mailSource = this.mailSources.get(i);
            mailSource.getMailDestination().startup();
            logger.debug("once() start", new Object[0]);
            MailFlowJob mfj = new MailFlowJob();
            try {
                mfj.setPattern(this.folderPattern == null ? null : Pattern.compile(this.folderPattern));
            }
            catch (PatternSyntaxException e) {
                logger.error("folderpattern is invalid due to {}", (Throwable)e, new Object[]{e.toString()});
            }
            mfj.setMailSource(mailSource);
            mfj.execute();
            logger.debug("once() end", new Object[0]);
        }
    }

    public void start() {
        logger.info("Start IMAPRiver ...", new Object[0]);
        try {
            this.sched = StdSchedulerFactory.getDefaultScheduler();
            if (this.sched.isShutdown()) {
                throw new Exception("Scheduler already down");
            }
            if (this.sched.isStarted()) {
                logger.debug("Scheduler already running", new Object[0]);
            }
            for (int i = 0; i < this.mailSources.size(); ++i) {
                MailSource mailSource = this.mailSources.get(i);
                mailSource.getMailDestination().startup();
                JobDataMap jdm = new JobDataMap();
                jdm.put("mailSource", (Object)mailSource);
                jdm.put("client", (Object)this.client);
                try {
                    if (this.folderPattern != null) {
                        jdm.put("pattern", (Object)Pattern.compile(this.folderPattern));
                    }
                }
                catch (PatternSyntaxException e) {
                    throw new Exception("folderpattern is invalid due to " + e, e);
                }
                JobDetail job = JobBuilder.newJob(MailFlowJob.class).usingJobData(jdm).build();
                Trigger trigger = null;
                if (StringUtils.isEmpty((String)this.schedule)) {
                    logger.info("Trigger interval is every {} seconds", new Object[]{this.interval.seconds()});
                    trigger = TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds((int)this.interval.seconds()).repeatForever()).build();
                } else {
                    logger.info("Trigger follows cron pattern {}", new Object[]{this.schedule});
                    trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.schedule)).build();
                }
                this.sched.scheduleJob(job, trigger);
            }
            this.sched.start();
            logger.info("IMAPRiver started", new Object[0]);
        }
        catch (Exception e) {
            logger.error("Unable to start IMAPRiver due to " + e, (Throwable)e, new Object[0]);
        }
    }

    private List<String> arrayNodeToList(Object arrayNode) {
        ArrayList<String> list = new ArrayList<String>();
        if (XContentMapValues.isArray((Object)arrayNode)) {
            for (Object node : (List)arrayNode) {
                String value = XContentMapValues.nodeStringValue(node, null);
                if (value == null) continue;
                list.add(value);
            }
        }
        return list;
    }

    private void getUserLogins(Map<String, Object> imapSettings) {
        String userSource = XContentMapValues.nodeStringValue((Object)imapSettings.get("user_source"), null);
        LdapLoginSource source = null;
        if ("ldap".equals(userSource)) {
            String masterUser = XContentMapValues.nodeStringValue((Object)imapSettings.get("master_user"), null);
            String masterPassword = XContentMapValues.nodeStringValue((Object)imapSettings.get("master_password"), null);
            source = new LdapLoginSource(imapSettings, masterUser, masterPassword);
        } else {
            String _user = XContentMapValues.nodeStringValue((Object)imapSettings.get("user"), null);
            String _password = XContentMapValues.nodeStringValue((Object)imapSettings.get("password"), null);
            if (_user != null && !_user.isEmpty()) {
                this.users.add(_user);
                this.passwords.add(_password);
            }
            List<String> _users = this.arrayNodeToList(imapSettings.get("users"));
            List<String> _passwords = this.arrayNodeToList(imapSettings.get("passwords"));
            if (_users != null && !_users.isEmpty()) {
                this.users.addAll(_users);
                this.passwords.addAll(_passwords);
            }
        }
        if (source != null) {
            this.users.addAll(source.getUserNames());
            this.passwords.addAll(source.getUserPasswords());
        }
    }

    public static void waitForYellowCluster(Client client) throws IOException {
        ClusterHealthStatus status = ClusterHealthStatus.YELLOW;
        try {
            logger.debug("waiting for cluster state {}", new Object[]{status.name()});
            ClusterHealthResponse healthResponse = (ClusterHealthResponse)client.admin().cluster().prepareHealth(new String[0]).setWaitForStatus(status).setTimeout(TimeValue.timeValueSeconds((long)30L)).execute().actionGet();
            if (healthResponse.isTimedOut()) {
                logger.error("Timeout while waiting for cluster state: {}, current cluster state is: {}", new Object[]{status.name(), healthResponse.getStatus().name()});
                throw new IOException("cluster state is " + healthResponse.getStatus().name() + " and not " + status.name() + ", cowardly refusing to continue with operations");
            }
            logger.debug("... cluster state ok", new Object[0]);
        }
        catch (Exception e) {
            logger.error("Exception while waiting for cluster state: {} due to ", (Throwable)e, new Object[]{status.name(), e.toString()});
            throw new IOException("timeout, cluster does not respond to health request, cowardly refusing to continue with operations", e);
        }
    }
}

