/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.report.interleaving;

import de.rwth.swc.coffee4j.algorithmic.interleaving.InterleavingCombinatorialTestGroup;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.process.report.util.CombinationFormatter;
import de.rwth.swc.coffee4j.engine.process.report.util.NoOpFormatter;
import de.rwth.swc.coffee4j.engine.process.report.util.ReportUtility;
import de.rwth.swc.coffee4j.engine.report.InterleavingExecutionReporter;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterleavingExecutionReporterForGeneration
implements InterleavingExecutionReporter {
    protected final Logger logger;
    protected CombinationFormatter formatter = new NoOpFormatter();

    public LoggingInterleavingExecutionReporterForGeneration() {
        this.logger = LoggerFactory.getLogger(LoggingInterleavingExecutionReporterForGeneration.class);
    }

    @Override
    public void interleavingGroupGenerated(InterleavingCombinatorialTestGroup group) {
        this.logger.info("Generated {}", (Object)group);
    }

    @Override
    public void interleavingGroupFinished(InterleavingCombinatorialTestGroup group, Map<Combination, Class<? extends Throwable>> exceptionInducingCombinations, Set<Combination> possiblyFailureInducingCombinations) {
        this.logger.info("Finished Testing with {}", (Object)group);
        this.logger.info(ReportUtility.getFormattedExceptionInducingCombinations(exceptionInducingCombinations, this.formatter));
        this.logger.info(ReportUtility.getFormattedFailureInducingCombinations(possiblyFailureInducingCombinations));
        if (possiblyFailureInducingCombinations != null && !possiblyFailureInducingCombinations.isEmpty()) {
            this.logger.info(ReportUtility.getWarningForErrorConstraintGeneration());
        }
    }

    @Override
    public void identificationStarted(InterleavingCombinatorialTestGroup group, Combination failingTestInput) {
        this.logger.info("Identification-process started for failing test input {}.", (Object)failingTestInput);
    }

    @Override
    public void identificationFinished(InterleavingCombinatorialTestGroup group, Set<Combination> exceptionInducingCombinations, Set<Combination> possiblyFailureInducingCombinations) {
        this.logger.info("Identification-process finished.");
        this.logger.info(ReportUtility.getFormattedExceptionInducingCombinations(exceptionInducingCombinations));
        this.logger.info(ReportUtility.getFormattedFailureInducingCombinations(possiblyFailureInducingCombinations));
    }

    @Override
    public void identificationTestInputGenerated(InterleavingCombinatorialTestGroup group, Combination testInput) {
        this.logger.info("Following test input was generated during identification: {} ", (Object)testInput);
    }

    @Override
    public void checkingStarted(InterleavingCombinatorialTestGroup group, Combination combinationToCheck) {
        this.logger.info("Checking Phase started for Combination {}", (Object)combinationToCheck);
    }

    @Override
    public void checkingFinished(InterleavingCombinatorialTestGroup group, Combination combinationToCheck, boolean passed) {
        this.logger.info("Checking Phase finished for Combination {}", (Object)combinationToCheck);
        if (passed) {
            this.logger.info("Checking passed.");
        } else {
            this.logger.info("Checking failed.");
        }
    }

    @Override
    public void testInputExecutionStarted(Combination testInput) {
        this.logger.info("Test Input Execution started for Combination {}", (Object)testInput);
    }

    @Override
    public void testInputExecutionFinished(Combination testInput, TestResult result) {
        this.logger.info("Test Input Execution finished for Combination {} with result {}", (Object)testInput, (Object)result);
    }
}

