/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.phase.sequential.generation;

import de.rwth.swc.coffee4j.algorithmic.report.ArgumentConverter;
import de.rwth.swc.coffee4j.algorithmic.report.Report;
import de.rwth.swc.coffee4j.algorithmic.report.ReportLevel;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithm;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroup;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroupGenerator;
import de.rwth.swc.coffee4j.algorithmic.sequential.report.GenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.TestInputGroupContext;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.report.SequentialExecutionReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SequentialExecutionReporterToGenerationReporterAdapter
implements GenerationReporter {
    private final SequentialExecutionReporter reporter;
    private final ArgumentConverter argumentConverter;
    private final ModelConverter modelConverter;
    private final Map<Object, TestInputGroupContext> testInputGroupContexts = new HashMap<Object, TestInputGroupContext>();

    public SequentialExecutionReporterToGenerationReporterAdapter(SequentialExecutionReporter reporter, ArgumentConverter argumentConverter, ModelConverter modelConverter) {
        this.reporter = (SequentialExecutionReporter)Preconditions.notNull((Object)reporter);
        this.argumentConverter = (ArgumentConverter)Preconditions.notNull((Object)argumentConverter);
        this.modelConverter = (ModelConverter)Preconditions.notNull((Object)modelConverter);
    }

    public void testInputGroupGenerated(TestInputGroup testInputGroup, TestInputGroupGenerator generator) {
        this.initializeContext(testInputGroup, generator);
        this.reporter.testInputGroupGenerated(this.convertTestInputGroup(testInputGroup), this.convertCombinations(testInputGroup.getTestInputs()));
    }

    private void initializeContext(TestInputGroup testInputGroup, TestInputGroupGenerator generator) {
        Object identifier = testInputGroup.getIdentifier();
        Object convertedIdentifier = this.argumentConverter.canConvert(identifier) ? this.argumentConverter.convert(identifier) : identifier;
        this.testInputGroupContexts.put(identifier, new TestInputGroupContext(convertedIdentifier, generator));
    }

    private TestInputGroupContext convertTestInputGroup(TestInputGroup testInputGroup) {
        return this.testInputGroupContexts.get(testInputGroup.getIdentifier());
    }

    private List<Combination> convertCombinations(Collection<int[]> combinations) {
        return combinations.stream().map(this.modelConverter::convertCombination).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private Combination convertCombination(int[] combination) {
        return this.modelConverter.convertCombination(combination);
    }

    public void testInputGroupFinished(TestInputGroup testInputGroup) {
        this.reporter.testInputGroupFinished(this.convertTestInputGroup(testInputGroup));
    }

    public void faultCharacterizationStarted(TestInputGroup testInputGroup, FaultCharacterizationAlgorithm algorithm) {
        this.reporter.faultCharacterizationStarted(this.convertTestInputGroup(testInputGroup), algorithm);
    }

    public void faultCharacterizationFinished(TestInputGroup testInputGroup, Map<int[], Class<? extends Throwable>> exceptionInducingCombinations, Set<int[]> possiblyFailureInducingCombinations) {
        this.reporter.faultCharacterizationFinished(this.convertTestInputGroup(testInputGroup), exceptionInducingCombinations.entrySet().stream().collect(Collectors.toMap(entry -> this.convertCombination((int[])entry.getKey()), Map.Entry::getValue)), this.convertCombinations(possiblyFailureInducingCombinations));
    }

    public void faultCharacterizationTestInputsGenerated(TestInputGroup testInputGroup, List<int[]> testInputs) {
        this.reporter.faultCharacterizationTestInputsGenerated(this.convertTestInputGroup(testInputGroup), new ArrayList<Combination>(this.convertCombinations(new HashSet<int[]>(testInputs))));
    }

    public void report(ReportLevel level, Report report) {
        Preconditions.notNull((Object)level);
        if (level.isWorseThanOrEqualTo(this.reporter.getReportLevel())) {
            report.convertArguments(this.argumentConverter);
            this.reporter.report(level, report);
        }
    }

    public void report(ReportLevel level, Supplier<Report> reportSupplier) {
        Preconditions.notNull((Object)level);
        Preconditions.notNull(reportSupplier);
        if (level.isWorseThanOrEqualTo(this.reporter.getReportLevel())) {
            Report report = reportSupplier.get();
            report.convertArguments(this.argumentConverter);
            this.reporter.report(level, report);
        }
    }
}

