/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.phase.sequential.classification;

import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.CachingDelegatingSequentialCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.GeneratingSequentialCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.process.phase.AbstractPhase;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.generation.SequentialGenerationContext;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.platform.commons.function.Try;

public class SequentialClassificationPhase
extends AbstractPhase<SequentialGenerationContext, Map<Combination, TestResult>, Combination> {
    protected final GeneratingSequentialCombinatorialTestManager testManager;
    protected final ModelConverter modelConverter;

    public SequentialClassificationPhase(SequentialGenerationContext context) {
        super(context);
        if (context.getGenerator() instanceof CachingDelegatingSequentialCombinatorialTestManager) {
            Preconditions.check((boolean)(((CachingDelegatingSequentialCombinatorialTestManager)context.getGenerator()).getGenerator() instanceof GeneratingSequentialCombinatorialTestManager));
            this.testManager = (GeneratingSequentialCombinatorialTestManager)((CachingDelegatingSequentialCombinatorialTestManager)context.getGenerator()).getGenerator();
        } else {
            Preconditions.check((boolean)(context.getGenerator() instanceof GeneratingSequentialCombinatorialTestManager));
            this.testManager = (GeneratingSequentialCombinatorialTestManager)context.getGenerator();
        }
        this.modelConverter = context.getModelConverter();
    }

    public Combination initialize(Map<Combination, TestResult> errorConstraintExceptionCausingTestInputs) {
        Optional optNextTestInput = this.testManager.initializeClassification(errorConstraintExceptionCausingTestInputs.entrySet().stream().map(testInput -> Map.entry(this.modelConverter.convertCombination((Combination)testInput.getKey()), (TestResult)testInput.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        Combination nextTestInput = null;
        if (optNextTestInput.isPresent()) {
            nextTestInput = this.modelConverter.convertCombination((int[])optNextTestInput.get());
        }
        return nextTestInput;
    }

    @Override
    public Combination execute(Map<Combination, TestResult> input) {
        Preconditions.notNull(input);
        Preconditions.check((boolean)Try.call(() -> !input.containsKey(null)).toOptional().orElse(true));
        Preconditions.check((boolean)Try.call(() -> !input.containsValue(null)).toOptional().orElse(true));
        Optional optEntry = input.entrySet().stream().findFirst();
        Map.Entry previouslyExecutedTest = null;
        if (optEntry.isPresent()) {
            previouslyExecutedTest = (Map.Entry)optEntry.get();
        }
        assert (previouslyExecutedTest != null);
        Optional optNextTestInput = this.testManager.generateNextTestInputForClassification(this.modelConverter.convertCombination((Combination)previouslyExecutedTest.getKey()), (TestResult)previouslyExecutedTest.getValue());
        Combination nextTestInput = null;
        if (optNextTestInput.isPresent()) {
            nextTestInput = this.modelConverter.convertCombination((int[])optNextTestInput.get());
        }
        return nextTestInput;
    }
}

