/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation;

import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.InterleavingCombinatorialTestConfiguration;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.InterleavingCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.interleaving.report.InterleavingGenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.execution.InterleavingExecutionConfiguration;
import de.rwth.swc.coffee4j.engine.configuration.model.InputParameterModel;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.process.extension.ExtensionExecutor;
import de.rwth.swc.coffee4j.engine.process.phase.PhaseContext;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation.InterleavingExecutionReporterToGenerationReporterAdapter;
import de.rwth.swc.coffee4j.engine.process.report.interleaving.LoggingInterleavingExecutionReporter;
import de.rwth.swc.coffee4j.engine.process.report.interleaving.LoggingInterleavingExecutionReporterForGeneration;
import de.rwth.swc.coffee4j.engine.report.DelegatingInterleavingExecutionReporter;
import de.rwth.swc.coffee4j.engine.report.DelegatingModelBasedArgumentConverter;
import de.rwth.swc.coffee4j.engine.report.InterleavingExecutionReporter;
import de.rwth.swc.coffee4j.engine.report.ModelBasedArgumentConverter;
import java.util.List;

public class InterleavingGenerationContext
implements PhaseContext {
    private final ModelConverter modelConverter;
    final InterleavingCombinatorialTestManager interleavingCombinatorialTestManager;
    private final ExtensionExecutor extensionExecutor;
    private final boolean isGenerating;

    public InterleavingGenerationContext(InterleavingExecutionConfiguration configuration, InputParameterModel model, ExtensionExecutor extensionExecutor) {
        this.extensionExecutor = (ExtensionExecutor)Preconditions.notNull((Object)extensionExecutor);
        this.modelConverter = ((InterleavingExecutionConfiguration)Preconditions.notNull((Object)configuration)).getModelConverterFactory().create(model);
        this.isGenerating = configuration.isGenerating();
        DelegatingModelBasedArgumentConverter argumentConverterManager = new DelegatingModelBasedArgumentConverter(configuration.getArgumentConverters());
        ((ModelBasedArgumentConverter)argumentConverterManager).initialize(this.modelConverter);
        InterleavingExecutionReporterToGenerationReporterAdapter reporterManager = new InterleavingExecutionReporterToGenerationReporterAdapter(this.buildDelegatingOrDefaultExecutionReporter(configuration.getExecutionReporters()), argumentConverterManager, this.modelConverter);
        InterleavingCombinatorialTestConfiguration testConfiguration = new InterleavingCombinatorialTestConfiguration(configuration.getTestInputGenerationStrategyFactory(), configuration.getIdentificationStrategyFactory(), configuration.getFeedbackCheckingStrategyFactory(), configuration.getClassificationStrategyFactory(), configuration.getConstraintCheckerFactory(), (InterleavingGenerationReporter)reporterManager);
        this.interleavingCombinatorialTestManager = configuration.getManagerFactory().create(testConfiguration, this.modelConverter.getConvertedModel());
    }

    protected InterleavingExecutionReporter buildDelegatingOrDefaultExecutionReporter(List<InterleavingExecutionReporter> executionReporters) {
        if (executionReporters.isEmpty()) {
            if (this.isGenerating) {
                return new LoggingInterleavingExecutionReporterForGeneration();
            }
            return new LoggingInterleavingExecutionReporter();
        }
        return new DelegatingInterleavingExecutionReporter(executionReporters);
    }

    public ModelConverter getModelConverter() {
        return this.modelConverter;
    }

    public InterleavingCombinatorialTestManager getTestManager() {
        return this.interleavingCombinatorialTestManager;
    }

    public ExtensionExecutor getExtensionExecutor() {
        return this.extensionExecutor;
    }
}

