/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.phase.execution;

import de.rwth.swc.coffee4j.algorithmic.configuration.execution.ExecutionMode;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.engine.configuration.TestMethodConfiguration;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.process.phase.AbstractPhase;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionContext;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExecutionPhase
extends AbstractPhase<ExecutionContext, List<Combination>, Map<Combination, TestResult>> {
    private ExecutionMode executionMode = ExecutionMode.EXECUTE_ALL;

    public ExecutionPhase(ExecutionContext executionContext) {
        super(executionContext);
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = Objects.requireNonNull(executionMode);
    }

    @Override
    public Map<Combination, TestResult> execute(List<Combination> input) {
        ((ExecutionContext)this.context).getExtensionExecutor().executeBeforeExecution(Collections.unmodifiableList(input));
        Map<Combination, TestResult> results = this.executeAllCombinations(input);
        return ((ExecutionContext)this.context).getExtensionExecutor().executeAfterExecution(new LinkedHashMap<Combination, TestResult>(results));
    }

    private Map<Combination, TestResult> executeAllCombinations(List<Combination> combinations) {
        LinkedHashMap<Combination, TestResult> results = new LinkedHashMap<Combination, TestResult>();
        boolean isFailFastMode = this.executionMode == ExecutionMode.FAIL_FAST;
        for (Combination combination : combinations) {
            ((ExecutionContext)this.context).getExecutionReporters().forEach(reporter -> reporter.testInputExecutionStarted(combination));
            TestResult testResult = this.executeCombinationDescriptor(combination);
            results.put(combination, testResult);
            ((ExecutionContext)this.context).getExecutionReporters().forEach(reporter -> reporter.testInputExecutionFinished(combination, testResult));
            if (!testResult.isUnsuccessful() || !isFailFastMode) continue;
            break;
        }
        return results;
    }

    private TestResult executeCombinationDescriptor(Combination combination) {
        TestMethodConfiguration testMethodConfiguration = ((ExecutionContext)this.context).getTestMethodConfiguration();
        return testMethodConfiguration.getTestInputExecutor().execute(combination);
    }
}

