/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.manager.sequential;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.TestMethodConfiguration;
import de.rwth.swc.coffee4j.engine.configuration.execution.SequentialExecutionConfiguration;
import de.rwth.swc.coffee4j.engine.configuration.extension.Extension;
import de.rwth.swc.coffee4j.engine.process.extension.DefaultExtensionExecutor;
import de.rwth.swc.coffee4j.engine.process.extension.ExtensionExecutorFactory;
import de.rwth.swc.coffee4j.engine.process.manager.ConflictDetector;
import de.rwth.swc.coffee4j.engine.process.manager.ConflictDetectorFactory;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionPhase;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionPhaseFactory;
import de.rwth.swc.coffee4j.engine.process.phase.model.ModelModificationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.model.ModelModificationPhaseFactory;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.characterization.FaultCharacterizationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.characterization.FaultCharacterizationPhaseFactory;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.classification.SequentialClassificationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.classification.SequentialClassificationPhaseFactory;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.generation.SequentialGenerationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.generation.SequentialGenerationPhaseFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SequentialPhaseManagerConfiguration {
    private final SequentialExecutionConfiguration executionConfiguration;
    private final TestMethodConfiguration testMethodConfiguration;
    private final List<Extension> extensions;
    private final ExtensionExecutorFactory extensionExecutorFactory;
    private final ExecutionPhaseFactory executionPhaseFactory;
    private final SequentialGenerationPhaseFactory generationPhaseFactory;
    private final FaultCharacterizationPhaseFactory faultCharacterizationPhaseFactory;
    private final SequentialClassificationPhaseFactory classificationPhaseFactory;
    private final ConflictDetectorFactory conflictDetectorFactory;
    private final ModelModificationPhaseFactory modelModificationPhaseFactory;

    private SequentialPhaseManagerConfiguration(Builder builder) {
        this.executionConfiguration = (SequentialExecutionConfiguration)Preconditions.notNull((Object)builder.executionConfiguration, (String)"executionConfiguration");
        this.testMethodConfiguration = (TestMethodConfiguration)Preconditions.notNull((Object)builder.testMethodConfiguration, (String)"testMethodConfiguration");
        this.extensions = Collections.unmodifiableList(new ArrayList<Extension>(builder.extensions));
        this.extensionExecutorFactory = (ExtensionExecutorFactory)Preconditions.notNull((Object)builder.extensionExecutorFactory, (String)"extensionExecutorFactory");
        this.executionPhaseFactory = (ExecutionPhaseFactory)Preconditions.notNull((Object)builder.executionPhaseFactory, (String)"executionPhaseFactory");
        this.generationPhaseFactory = (SequentialGenerationPhaseFactory)Preconditions.notNull((Object)builder.generationPhaseFactory, (String)"generationPhaseFactory");
        this.faultCharacterizationPhaseFactory = (FaultCharacterizationPhaseFactory)Preconditions.notNull((Object)builder.faultCharacterizationPhaseFactory, (String)"faultCharacterizationPhaseFactory");
        this.classificationPhaseFactory = (SequentialClassificationPhaseFactory)Preconditions.notNull((Object)builder.classificationPhaseFactory, (String)"classificationPhaseFactory");
        this.conflictDetectorFactory = (ConflictDetectorFactory)Preconditions.notNull((Object)builder.conflictDetectorFactory, (String)"conflictDetectorFactory");
        this.modelModificationPhaseFactory = (ModelModificationPhaseFactory)Preconditions.notNull((Object)builder.modelModificationPhaseFactory, (String)"modelModificationPhaseFactory");
    }

    public SequentialExecutionConfiguration getExecutionConfiguration() {
        return this.executionConfiguration;
    }

    public TestMethodConfiguration getTestMethodConfiguration() {
        return this.testMethodConfiguration;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public ModelModificationPhaseFactory getModelModificationPhaseFactory() {
        return this.modelModificationPhaseFactory;
    }

    public ExtensionExecutorFactory getExtensionExecutorFactory() {
        return this.extensionExecutorFactory;
    }

    public ExecutionPhaseFactory getExecutionPhaseFactory() {
        return this.executionPhaseFactory;
    }

    public SequentialGenerationPhaseFactory getGenerationPhaseFactory() {
        return this.generationPhaseFactory;
    }

    public FaultCharacterizationPhaseFactory getFaultCharacterizationPhaseFactory() {
        return this.faultCharacterizationPhaseFactory;
    }

    public SequentialClassificationPhaseFactory getClassificationPhaseFactory() {
        return this.classificationPhaseFactory;
    }

    public ConflictDetectorFactory getConflictDetectorFactory() {
        return this.conflictDetectorFactory;
    }

    public Builder toBuilder() {
        return new Builder().executionConfiguration(this.executionConfiguration).testMethodConfiguration(this.testMethodConfiguration).extensions(this.extensions).extensionExecutorFactory(this.extensionExecutorFactory).executionPhaseFactory(this.executionPhaseFactory).generationPhaseFactory(this.generationPhaseFactory).faultCharacterizationPhaseFactory(this.faultCharacterizationPhaseFactory).classificationPhaseFactory(this.classificationPhaseFactory).conflictDetectorFactory(this.conflictDetectorFactory).modelModificationPhaseFactory(this.modelModificationPhaseFactory);
    }

    public static Builder phaseManagerConfiguration() {
        return new Builder();
    }

    public static class Builder {
        private SequentialExecutionConfiguration executionConfiguration;
        private TestMethodConfiguration testMethodConfiguration;
        private final List<Extension> extensions = new ArrayList<Extension>();
        private ExtensionExecutorFactory extensionExecutorFactory = DefaultExtensionExecutor::new;
        private ExecutionPhaseFactory executionPhaseFactory = ExecutionPhase::new;
        private SequentialGenerationPhaseFactory generationPhaseFactory = SequentialGenerationPhase::new;
        private FaultCharacterizationPhaseFactory faultCharacterizationPhaseFactory = FaultCharacterizationPhase::new;
        private SequentialClassificationPhaseFactory classificationPhaseFactory = SequentialClassificationPhase::new;
        private ConflictDetectorFactory conflictDetectorFactory = ConflictDetector::new;
        private ModelModificationPhaseFactory modelModificationPhaseFactory = ModelModificationPhase::new;

        public Builder executionConfiguration(SequentialExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        public Builder testMethodConfiguration(TestMethodConfiguration testMethodConfiguration) {
            this.testMethodConfiguration = testMethodConfiguration;
            return this;
        }

        public Builder extensions(List<Extension> extensions) {
            this.extensions.addAll(extensions);
            return this;
        }

        public Builder extensionExecutorFactory(ExtensionExecutorFactory extensionExecutorFactory) {
            this.extensionExecutorFactory = extensionExecutorFactory;
            return this;
        }

        public Builder executionPhaseFactory(ExecutionPhaseFactory abstractExecutionPhaseFactory) {
            this.executionPhaseFactory = abstractExecutionPhaseFactory;
            return this;
        }

        public Builder generationPhaseFactory(SequentialGenerationPhaseFactory generationPhaseFactory) {
            this.generationPhaseFactory = generationPhaseFactory;
            return this;
        }

        public Builder faultCharacterizationPhaseFactory(FaultCharacterizationPhaseFactory faultCharacterizationPhaseFactory) {
            this.faultCharacterizationPhaseFactory = faultCharacterizationPhaseFactory;
            return this;
        }

        public Builder classificationPhaseFactory(SequentialClassificationPhaseFactory classificationPhaseFactory) {
            this.classificationPhaseFactory = classificationPhaseFactory;
            return this;
        }

        public Builder conflictDetectorFactory(ConflictDetectorFactory conflictDetectorFactory) {
            this.conflictDetectorFactory = conflictDetectorFactory;
            return this;
        }

        public Builder modelModificationPhaseFactory(ModelModificationPhaseFactory modelModificationPhaseFactory) {
            this.modelModificationPhaseFactory = modelModificationPhaseFactory;
            return this;
        }

        public SequentialPhaseManagerConfiguration build() {
            return new SequentialPhaseManagerConfiguration(this);
        }
    }
}

