/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.manager.sequential;

import de.rwth.swc.coffee4j.algorithmic.ErrorConstraintException;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.process.manager.sequential.AbstractSequentialPhaseManager;
import de.rwth.swc.coffee4j.engine.process.manager.sequential.SequentialPhaseManagerConfiguration;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.classification.SequentialClassificationPhase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultGeneratingSequentialPhaseManager
extends AbstractSequentialPhaseManager {
    private final Map<Combination, TestResult> errorConstraintExceptionCausingTestInputs = new HashMap<Combination, TestResult>();
    private SequentialClassificationPhase classificationPhase;

    public DefaultGeneratingSequentialPhaseManager(SequentialPhaseManagerConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected void createTestPhases() {
        super.createTestPhases();
        this.classificationPhase = this.configuration.getClassificationPhaseFactory().create(this.generationContext);
    }

    @Override
    protected void collectErrorConstraintExceptionCausingTestInputs(Map<Combination, TestResult> executionResults) {
        this.errorConstraintExceptionCausingTestInputs.putAll(executionResults.entrySet().stream().filter(testInput -> ((TestResult)testInput.getValue()).isExceptionalSuccessful()).filter(testInput -> ((TestResult)testInput.getValue()).getResultValue().orElse(null) instanceof ErrorConstraintException).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @Override
    protected void executeClassificationPhase() {
        Combination nextTestInput = this.classificationPhase.initialize(this.errorConstraintExceptionCausingTestInputs);
        while (nextTestInput != null) {
            Map<Combination, TestResult> executionResult = this.executionPhase.execute(List.of(nextTestInput));
            nextTestInput = this.classificationPhase.execute(executionResult);
        }
    }
}

