/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.manager;

import de.rwth.swc.coffee4j.algorithmic.Coffee4JException;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictDetectionConfiguration;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictDetectionManager;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisHittingSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.MissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.conflict.ReduceBasedDiagnosisHittingSetBuilder;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.process.report.LoggingConflictDetectionReporter;
import java.util.List;

public class ConflictDetector {
    private final ConflictDetectionConfiguration conflictDetectionConfiguration;
    private final LoggingConflictDetectionReporter conflictDetectionReporter;
    private final ModelConverter modelConverter;

    public ConflictDetector(ConflictDetectionConfiguration conflictDetectionConfiguration, ModelConverter modelConverter) {
        this.conflictDetectionConfiguration = conflictDetectionConfiguration;
        this.conflictDetectionReporter = new LoggingConflictDetectionReporter(modelConverter);
        this.modelConverter = modelConverter;
    }

    public void diagnoseConstraints() {
        if (this.conflictDetectionConfiguration.isConflictDetectionEnabled()) {
            boolean isConflictFree = this.checkConstraintsForConflicts();
            if (this.conflictDetectionConfiguration.shouldAbort() && !isConflictFree) {
                throw new Coffee4JException("Error: conflicts among constraints detected");
            }
        }
    }

    private boolean checkConstraintsForConflicts() {
        List<MissingInvalidTuple> missingInvalidTuples = this.detectMissingInvalidTuples();
        if (missingInvalidTuples.isEmpty()) {
            return true;
        }
        this.conflictDetectionReporter.reportDetectedMissingInvalidTuples(missingInvalidTuples);
        if (this.conflictDetectionConfiguration.isConflictDiagnosisEnabled()) {
            List<DiagnosisHittingSet> minimalHittingSets = this.computeMinimalDiagnosisHittingSets(missingInvalidTuples);
            this.conflictDetectionReporter.reportMinimalDiagnosisHittingSets(minimalHittingSets);
        }
        return false;
    }

    private List<MissingInvalidTuple> detectMissingInvalidTuples() {
        ConflictDetectionManager conflictDetectionManager = new ConflictDetectionManager(this.conflictDetectionConfiguration, this.modelConverter.getConvertedModel());
        return conflictDetectionManager.detectMissingInvalidTuples();
    }

    private List<DiagnosisHittingSet> computeMinimalDiagnosisHittingSets(List<MissingInvalidTuple> missingInvalidTuples) {
        Preconditions.check((boolean)this.conflictDetectionConfiguration.isConflictDiagnosisEnabled());
        ReduceBasedDiagnosisHittingSetBuilder builder = new ReduceBasedDiagnosisHittingSetBuilder(this.modelConverter.getConvertedModel());
        return builder.computeMinimalDiagnosisHittingSets(missingInvalidTuples);
    }
}

