/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.interleaving;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.TestMethodConfiguration;
import de.rwth.swc.coffee4j.engine.configuration.execution.InterleavingExecutionConfiguration;
import de.rwth.swc.coffee4j.engine.configuration.extension.Extension;
import de.rwth.swc.coffee4j.engine.process.extension.DefaultExtensionExecutor;
import de.rwth.swc.coffee4j.engine.process.extension.ExtensionExecutorFactory;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionPhase;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionPhaseFactory;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.checking.CheckingPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.checking.CheckingPhaseFactory;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.classification.InterleavingClassificationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.classification.InterleavingClassificationPhaseFactory;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation.InterleavingGenerationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation.InterleavingGenerationPhaseFactory;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.identification.IdentificationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.identification.IdentificationPhaseFactory;
import de.rwth.swc.coffee4j.engine.process.phase.model.ModelModificationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.model.ModelModificationPhaseFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InterleavingPhaseManagerConfiguration {
    private final InterleavingExecutionConfiguration executionConfiguration;
    private final TestMethodConfiguration testMethodConfiguration;
    private final List<Extension> extensions;
    private final ExtensionExecutorFactory extensionExecutorFactory;
    private final ExecutionPhaseFactory executionPhaseFactory;
    private final InterleavingGenerationPhaseFactory generationPhaseFactory;
    private final IdentificationPhaseFactory identificationPhaseFactory;
    private final CheckingPhaseFactory checkingPhaseFactory;
    private final InterleavingClassificationPhaseFactory classificationPhaseFactory;
    private final ModelModificationPhaseFactory modelModificationPhaseFactory;

    private InterleavingPhaseManagerConfiguration(Builder builder) {
        this.executionConfiguration = (InterleavingExecutionConfiguration)Preconditions.notNull((Object)builder.executionConfiguration);
        this.testMethodConfiguration = (TestMethodConfiguration)Preconditions.notNull((Object)builder.testMethodConfiguration);
        this.extensions = Collections.unmodifiableList((List)Preconditions.notNull(builder.extensions));
        this.extensionExecutorFactory = (ExtensionExecutorFactory)Preconditions.notNull((Object)builder.extensionExecutorFactory);
        this.executionPhaseFactory = (ExecutionPhaseFactory)Preconditions.notNull((Object)builder.executionPhaseFactory);
        this.generationPhaseFactory = (InterleavingGenerationPhaseFactory)Preconditions.notNull((Object)builder.generationPhaseFactory);
        this.identificationPhaseFactory = (IdentificationPhaseFactory)Preconditions.notNull((Object)builder.identificationPhaseFactory);
        this.checkingPhaseFactory = (CheckingPhaseFactory)Preconditions.notNull((Object)builder.checkingPhaseFactory);
        this.classificationPhaseFactory = (InterleavingClassificationPhaseFactory)Preconditions.notNull((Object)builder.classificationPhaseFactory);
        this.modelModificationPhaseFactory = (ModelModificationPhaseFactory)Preconditions.notNull((Object)builder.modelModificationPhaseFactory);
    }

    public InterleavingExecutionConfiguration getExecutionConfiguration() {
        return this.executionConfiguration;
    }

    public TestMethodConfiguration getTestMethodConfiguration() {
        return this.testMethodConfiguration;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public ExtensionExecutorFactory getExtensionExecutorFactory() {
        return this.extensionExecutorFactory;
    }

    public ExecutionPhaseFactory getExecutionPhaseFactory() {
        return this.executionPhaseFactory;
    }

    public InterleavingGenerationPhaseFactory getGenerationPhaseFactory() {
        return this.generationPhaseFactory;
    }

    public IdentificationPhaseFactory getIdentificationPhaseFactory() {
        return this.identificationPhaseFactory;
    }

    public CheckingPhaseFactory getCheckingPhaseFactory() {
        return this.checkingPhaseFactory;
    }

    public InterleavingClassificationPhaseFactory getClassificationPhaseFactory() {
        return this.classificationPhaseFactory;
    }

    public ModelModificationPhaseFactory getModelModificationPhaseFactory() {
        return this.modelModificationPhaseFactory;
    }

    public Builder toBuilder() {
        return InterleavingPhaseManagerConfiguration.phaseManagerConfiguration().executionConfiguration(this.executionConfiguration).testMethodConfiguration(this.testMethodConfiguration).extensions(this.extensions).extensionExecutorFactory(this.extensionExecutorFactory).executionPhaseFactory(this.executionPhaseFactory).generationPhaseFactory(this.generationPhaseFactory).identificationPhaseFactory(this.identificationPhaseFactory).checkingPhaseFactory(this.checkingPhaseFactory).classificationPhaseFactory(this.classificationPhaseFactory).modelModificationPhaseFactory(this.modelModificationPhaseFactory);
    }

    public static Builder phaseManagerConfiguration() {
        return new Builder();
    }

    public static class Builder {
        private InterleavingExecutionConfiguration executionConfiguration;
        private TestMethodConfiguration testMethodConfiguration;
        private final List<Extension> extensions = new ArrayList<Extension>();
        private ExtensionExecutorFactory extensionExecutorFactory = DefaultExtensionExecutor::new;
        private ExecutionPhaseFactory executionPhaseFactory = ExecutionPhase::new;
        private InterleavingGenerationPhaseFactory generationPhaseFactory = InterleavingGenerationPhase::new;
        private IdentificationPhaseFactory identificationPhaseFactory = IdentificationPhase::new;
        private CheckingPhaseFactory checkingPhaseFactory = CheckingPhase::new;
        private InterleavingClassificationPhaseFactory classificationPhaseFactory = InterleavingClassificationPhase::new;
        private ModelModificationPhaseFactory modelModificationPhaseFactory = ModelModificationPhase::new;

        public Builder executionConfiguration(InterleavingExecutionConfiguration configuration) {
            this.executionConfiguration = configuration;
            return this;
        }

        public Builder testMethodConfiguration(TestMethodConfiguration testMethodConfiguration) {
            this.testMethodConfiguration = testMethodConfiguration;
            return this;
        }

        public Builder extensions(Collection<Extension> extensions) {
            this.extensions.addAll(extensions);
            return this;
        }

        public Builder extensionExecutorFactory(ExtensionExecutorFactory extensionExecutorFactory) {
            this.extensionExecutorFactory = extensionExecutorFactory;
            return this;
        }

        public Builder executionPhaseFactory(ExecutionPhaseFactory executionPhaseFactory) {
            this.executionPhaseFactory = executionPhaseFactory;
            return this;
        }

        public Builder generationPhaseFactory(InterleavingGenerationPhaseFactory generationPhaseFactory) {
            this.generationPhaseFactory = generationPhaseFactory;
            return this;
        }

        public Builder identificationPhaseFactory(IdentificationPhaseFactory identificationPhaseFactory) {
            this.identificationPhaseFactory = identificationPhaseFactory;
            return this;
        }

        public Builder checkingPhaseFactory(CheckingPhaseFactory checkingPhaseFactory) {
            this.checkingPhaseFactory = checkingPhaseFactory;
            return this;
        }

        public Builder classificationPhaseFactory(InterleavingClassificationPhaseFactory classificationPhaseFactory) {
            this.classificationPhaseFactory = classificationPhaseFactory;
            return this;
        }

        public Builder modelModificationPhaseFactory(ModelModificationPhaseFactory modelModificationPhaseFactory) {
            this.modelModificationPhaseFactory = modelModificationPhaseFactory;
            return this;
        }

        public InterleavingPhaseManagerConfiguration build() {
            return new InterleavingPhaseManagerConfiguration(this);
        }
    }
}

