/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.interleaving;

import de.rwth.swc.coffee4j.algorithmic.ErrorConstraintException;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.DefaultGeneratingInterleavingManager;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.InterleavingCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.TestMethodConfiguration;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.InputParameterModel;
import de.rwth.swc.coffee4j.engine.configuration.model.Parameter;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.Constraint;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.tuplebased.TupleBasedConstraint;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.process.extension.ExtensionExecutor;
import de.rwth.swc.coffee4j.engine.process.interleaving.DynamicInterleavingPhaseManagerConfiguration;
import de.rwth.swc.coffee4j.engine.process.interleaving.HashMapResultCache;
import de.rwth.swc.coffee4j.engine.process.interleaving.ResultCache;
import de.rwth.swc.coffee4j.engine.process.manager.PhaseManager;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionContext;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.checking.CheckingPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.classification.InterleavingClassificationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation.InterleavingGenerationContext;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation.InterleavingGenerationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.identification.IdentificationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.model.ModelModificationContext;
import de.rwth.swc.coffee4j.engine.process.phase.model.ModelModificationPhase;
import de.rwth.swc.coffee4j.engine.report.DelegatingInterleavingExecutionReporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultDynamicInterleavingPhaseManager
implements PhaseManager {
    private final ResultCache cache = new HashMapResultCache();
    private DynamicInterleavingPhaseManagerConfiguration configuration;
    private ExecutionContext executionContext;
    private InterleavingGenerationContext generationContext;
    private ExtensionExecutor extensionExecutor;
    private ExecutionPhase executionPhase;
    private InterleavingGenerationPhase generationPhase;
    private IdentificationPhase identificationPhase;
    private CheckingPhase checkingPhase;
    private InterleavingClassificationPhase classificationPhase;
    private final InputParameterModel initialInputParameterModel;

    public DefaultDynamicInterleavingPhaseManager(DynamicInterleavingPhaseManagerConfiguration configuration) {
        this.configuration = (DynamicInterleavingPhaseManagerConfiguration)Preconditions.notNull((Object)configuration);
        this.initialInputParameterModel = (InputParameterModel)Preconditions.notNull((Object)configuration.getTestMethodConfiguration().getInputParameterModel());
    }

    @Override
    public void run() {
        this.executeModelModificationPhase();
        this.createContexts();
        this.createPhases();
        this.runOneInterleavingTestingIteration();
        this.executeClassificationPhase();
        this.updateConfiguration();
        this.runOneInterleavingTestingIteration();
    }

    private void executeModelModificationPhase() {
        this.extensionExecutor = this.configuration.getExtensionExecutorFactory().create(this.configuration.getExtensions());
        ModelModificationContext context = new ModelModificationContext(this.extensionExecutor, new DelegatingInterleavingExecutionReporter(this.configuration.getExecutionConfiguration().getExecutionReporters()));
        ModelModificationPhase phase = this.configuration.getModelModificationPhaseFactory().create(context);
        InputParameterModel model = this.configuration.getTestMethodConfiguration().getInputParameterModel();
        InputParameterModel modifiedModel = phase.execute(model);
        this.configuration = this.configuration.toBuilder().testMethodConfiguration(this.configuration.getTestMethodConfiguration().toBuilder().inputParameterModel(modifiedModel).build()).build();
    }

    private void createContexts() {
        this.executionContext = ExecutionContext.createExecutionContext(this.extensionExecutor, this.configuration.getTestMethodConfiguration(), this.configuration.getExecutionConfiguration().getExecutionReporters());
        this.generationContext = new InterleavingGenerationContext(this.configuration.getErrorConstraintGenerationExecutionConfiguration(), this.initialInputParameterModel, this.extensionExecutor);
    }

    private void createPhases() {
        this.executionPhase = this.configuration.getExecutionPhaseFactory().create(this.executionContext);
        this.generationPhase = this.configuration.getGenerationPhaseFactory().create(this.generationContext);
        this.identificationPhase = this.configuration.getIdentificationPhaseFactory().create(this.generationContext);
        this.checkingPhase = this.configuration.getCheckingPhaseFactory().create(this.generationContext);
        this.classificationPhase = this.configuration.getClassificationPhaseFactory().create(this.generationContext);
    }

    private void runOneInterleavingTestingIteration() {
        Combination nextTestInput = this.generationPhase.execute((Map<Combination, TestResult>)new HashMap<Combination, TestResult>());
        while (nextTestInput != null) {
            Map<Combination, TestResult> executionResult = this.runTestInput(nextTestInput);
            TestResult result = executionResult.get(nextTestInput);
            if (!result.isSuccessful()) {
                this.extensionExecutor.executeBeforeFaultCharacterization(executionResult);
                nextTestInput = this.identificationPhase.initialize(nextTestInput, result);
                List<Combination> generatedTestInputsDuringIdentification = Collections.emptyList();
                while (!this.checkingPhase.failureInducingCombinationsFound()) {
                    generatedTestInputsDuringIdentification = new ArrayList();
                    while (nextTestInput != null) {
                        generatedTestInputsDuringIdentification.add(nextTestInput);
                        executionResult = this.runTestInput(nextTestInput);
                        nextTestInput = this.identificationPhase.execute(executionResult);
                    }
                    nextTestInput = this.checkingPhase.initialize();
                    while (nextTestInput != null) {
                        while (nextTestInput != null) {
                            executionResult = this.runTestInput(nextTestInput);
                            nextTestInput = this.checkingPhase.execute(executionResult);
                        }
                        nextTestInput = this.checkingPhase.initialize();
                    }
                    if (this.checkingPhase.failureInducingCombinationsFound()) continue;
                    nextTestInput = this.identificationPhase.reinitialize();
                }
                this.extensionExecutor.executeAfterFaultCharacterization(generatedTestInputsDuringIdentification);
            }
            nextTestInput = this.generationPhase.execute(executionResult);
        }
    }

    private Map<Combination, TestResult> runTestInput(Combination nextTestInput) {
        Map<Object, Object> executionResult;
        if (!this.cache.containsResultFor(nextTestInput)) {
            executionResult = this.executionPhase.execute(Collections.singletonList(nextTestInput));
            this.cache.addResultIfAbsentFor(nextTestInput, (TestResult)executionResult.get(nextTestInput));
        } else {
            executionResult = new HashMap<Combination, TestResult>();
            executionResult.put(nextTestInput, this.cache.getResultFor(nextTestInput));
        }
        return executionResult;
    }

    private void executeClassificationPhase() {
        Combination nextTestInput = this.classificationPhase.initialize(((HashMapResultCache)this.cache).getResults().entrySet().stream().filter(testInput -> ((TestResult)testInput.getValue()).isExceptionalSuccessful()).filter(testInput -> ((TestResult)testInput.getValue()).getResultValue().orElse(null) instanceof ErrorConstraintException).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        while (nextTestInput != null) {
            Map<Combination, TestResult> executionResult = this.runTestInput(nextTestInput);
            nextTestInput = this.classificationPhase.execute(executionResult);
        }
    }

    private void updateConfiguration() {
        ModelConverter converter = this.generationContext.getModelConverter();
        Set foundExceptionInducingCombinations = ((DefaultGeneratingInterleavingManager)this.generationContext.getTestManager()).getMinimalExceptionInducingCombinations().keySet();
        HashSet<Constraint> errorConstraints = new HashSet<Constraint>();
        List<String> parameterNames = this.initialInputParameterModel.getParameters().stream().map(Parameter::getName).collect(Collectors.toList());
        int id = 0;
        for (int[] combination : foundExceptionInducingCombinations) {
            errorConstraints.add(new TupleBasedConstraint("exceptionInducingCombination-" + id++, parameterNames, converter.convertCombination(combination)));
        }
        InputParameterModel newInputParameterModel = this.initialInputParameterModel.toBuilder().errorConstraints(errorConstraints).build();
        TestMethodConfiguration newTestMethodConfiguration = this.configuration.getTestMethodConfiguration().toBuilder().inputParameterModel(newInputParameterModel).build();
        this.configuration = this.configuration.toBuilder().testMethodConfiguration(newTestMethodConfiguration).build();
        this.createContexts();
        InterleavingCombinatorialTestManager newTestManager = this.generationContext.getTestManager();
        for (Map.Entry<Combination, TestResult> testInput : ((HashMapResultCache)this.cache).getResults().entrySet()) {
            if (!testInput.getValue().isSuccessful()) continue;
            newTestManager.updateCoverage(converter.convertCombination(testInput.getKey()));
        }
        this.createPhases();
    }
}

