/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.interleaving;

import de.rwth.swc.coffee4j.algorithmic.ErrorConstraintException;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.InputParameterModel;
import de.rwth.swc.coffee4j.engine.process.extension.ExtensionExecutor;
import de.rwth.swc.coffee4j.engine.process.interleaving.HashMapResultCache;
import de.rwth.swc.coffee4j.engine.process.interleaving.InterleavingPhaseManagerConfiguration;
import de.rwth.swc.coffee4j.engine.process.interleaving.ResultCache;
import de.rwth.swc.coffee4j.engine.process.manager.PhaseManager;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionContext;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.checking.CheckingPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation.InterleavingGenerationContext;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation.InterleavingGenerationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.identification.IdentificationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.model.ModelModificationContext;
import de.rwth.swc.coffee4j.engine.process.phase.model.ModelModificationPhase;
import de.rwth.swc.coffee4j.engine.report.DelegatingInterleavingExecutionReporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractInterleavingPhaseManager
implements PhaseManager {
    protected final ResultCache cache = new HashMapResultCache();
    protected InterleavingPhaseManagerConfiguration configuration;
    protected ExecutionContext executionContext;
    protected InterleavingGenerationContext generationContext;
    protected ExtensionExecutor extensionExecutor;
    protected ExecutionPhase executionPhase;
    protected InterleavingGenerationPhase generationPhase;
    protected IdentificationPhase identificationPhase;
    protected CheckingPhase checkingPhase;

    public AbstractInterleavingPhaseManager(InterleavingPhaseManagerConfiguration configuration) {
        this.configuration = (InterleavingPhaseManagerConfiguration)Preconditions.notNull((Object)configuration);
    }

    @Override
    public void run() {
        this.executeModelModificationPhase();
        this.createContexts();
        this.createPhases();
        Combination nextTestInput = this.generationPhase.execute((Map<Combination, TestResult>)new HashMap<Combination, TestResult>());
        while (nextTestInput != null) {
            Map<Combination, TestResult> executionResult = this.runTestInput(nextTestInput);
            TestResult result = executionResult.get(nextTestInput);
            if (result.isSuccessful()) {
                nextTestInput = this.generationPhase.execute(executionResult);
                continue;
            }
            this.extensionExecutor.executeBeforeFaultCharacterization(executionResult);
            nextTestInput = this.identificationPhase.initialize(nextTestInput, result);
            List<Combination> generatedTestInputsDuringIdentification = Collections.emptyList();
            while (!this.checkingPhase.failureInducingCombinationsFound()) {
                generatedTestInputsDuringIdentification = new ArrayList();
                while (nextTestInput != null) {
                    generatedTestInputsDuringIdentification.add(nextTestInput);
                    executionResult = this.runTestInput(nextTestInput);
                    nextTestInput = this.identificationPhase.execute(executionResult);
                }
                nextTestInput = this.checkingPhase.initialize();
                while (nextTestInput != null) {
                    while (nextTestInput != null) {
                        executionResult = this.runTestInput(nextTestInput);
                        nextTestInput = this.checkingPhase.execute(executionResult);
                    }
                    nextTestInput = this.checkingPhase.initialize();
                }
                if (this.checkingPhase.failureInducingCombinationsFound()) continue;
                nextTestInput = this.identificationPhase.reinitialize();
            }
            this.extensionExecutor.executeAfterFaultCharacterization(generatedTestInputsDuringIdentification);
            nextTestInput = this.generationPhase.execute(executionResult);
        }
        this.executeClassificationPhase(((HashMapResultCache)this.cache).getResults().entrySet().stream().filter(testInput -> ((TestResult)testInput.getValue()).isExceptionalSuccessful()).filter(testInput -> ((TestResult)testInput.getValue()).getResultValue().orElse(null) instanceof ErrorConstraintException).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private void executeModelModificationPhase() {
        this.extensionExecutor = this.configuration.getExtensionExecutorFactory().create(this.configuration.getExtensions());
        ModelModificationContext context = new ModelModificationContext(this.extensionExecutor, new DelegatingInterleavingExecutionReporter(this.configuration.getExecutionConfiguration().getExecutionReporters()));
        ModelModificationPhase phase = this.configuration.getModelModificationPhaseFactory().create(context);
        InputParameterModel model = this.configuration.getTestMethodConfiguration().getInputParameterModel();
        InputParameterModel modifiedModel = phase.execute(model);
        this.configuration = this.configuration.toBuilder().testMethodConfiguration(this.configuration.getTestMethodConfiguration().toBuilder().inputParameterModel(modifiedModel).build()).build();
    }

    private void createContexts() {
        this.executionContext = ExecutionContext.createExecutionContext(this.extensionExecutor, this.configuration.getTestMethodConfiguration(), this.configuration.getExecutionConfiguration().getExecutionReporters());
        this.generationContext = new InterleavingGenerationContext(this.configuration.getExecutionConfiguration(), this.configuration.getTestMethodConfiguration().getInputParameterModel(), this.extensionExecutor);
    }

    protected void createPhases() {
        this.executionPhase = this.configuration.getExecutionPhaseFactory().create(this.executionContext);
        this.executionPhase.setExecutionMode(this.configuration.getExecutionConfiguration().getExecutionMode());
        this.generationPhase = this.configuration.getGenerationPhaseFactory().create(this.generationContext);
        this.identificationPhase = this.configuration.getIdentificationPhaseFactory().create(this.generationContext);
        this.checkingPhase = this.configuration.getCheckingPhaseFactory().create(this.generationContext);
    }

    protected abstract void executeClassificationPhase(Map<Combination, TestResult> var1);

    protected Map<Combination, TestResult> runTestInput(Combination nextTestInput) {
        Map<Object, Object> executionResult;
        if (!this.cache.containsResultFor(nextTestInput)) {
            executionResult = this.executionPhase.execute(Collections.singletonList(nextTestInput));
            this.cache.addResultIfAbsentFor(nextTestInput, (TestResult)executionResult.get(nextTestInput));
        } else {
            executionResult = new HashMap<Combination, TestResult>();
            executionResult.put(nextTestInput, this.cache.getResultFor(nextTestInput));
        }
        return executionResult;
    }
}

