/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.converter.model;

import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.PrimitiveSeed;
import de.rwth.swc.coffee4j.algorithmic.model.PrimitiveStrengthGroup;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.InputParameterModel;
import de.rwth.swc.coffee4j.engine.configuration.model.Parameter;
import de.rwth.swc.coffee4j.engine.configuration.model.Seed;
import de.rwth.swc.coffee4j.engine.configuration.model.StrengthGroup;
import de.rwth.swc.coffee4j.engine.configuration.model.Value;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.Constraint;
import de.rwth.swc.coffee4j.engine.converter.constraints.IndexBasedConstraintConverter;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class IndexBasedModelConverter
implements ModelConverter {
    private final InputParameterModel model;
    private final Object2IntMap<Parameter> parameterToIdMap = new Object2IntOpenHashMap();
    private final Map<Parameter, Object2IntMap<Value>> parameterValueToIdMap = new HashMap<Parameter, Object2IntMap<Value>>();
    private final Map<Constraint, TupleList> constraintToTuplesListMap = new HashMap<Constraint, TupleList>();
    private final Map<TupleList, Constraint> tuplesListToConstraintMap = new HashMap<TupleList, Constraint>();
    private final CompleteTestModel convertedModel;

    public IndexBasedModelConverter(InputParameterModel model) {
        this.model = (InputParameterModel)Preconditions.notNull((Object)model);
        this.initializeConversionMaps();
        this.convertTuplesLists();
        this.convertedModel = this.createConvertedModel();
    }

    private void initializeConversionMaps() {
        for (int parameterId = 0; parameterId < this.model.size(); ++parameterId) {
            Parameter correspondingParameter = this.model.getParameters().get(parameterId);
            Object2IntMap valueToIdMap = this.parameterValueToIdMap.computeIfAbsent(correspondingParameter, parameter -> new Object2IntOpenHashMap());
            this.parameterToIdMap.put((Object)correspondingParameter, parameterId);
            for (int valueId = 0; valueId < correspondingParameter.size(); ++valueId) {
                valueToIdMap.put((Object)correspondingParameter.getValues().get(valueId), valueId);
            }
        }
    }

    private void convertTuplesLists() {
        ArrayList<Constraint> allConstraints = new ArrayList<Constraint>(this.model.getExclusionConstraints());
        allConstraints.addAll(this.model.getErrorConstraints());
        ArrayList<TupleList> correspondingTupleLists = new ArrayList<TupleList>();
        int id = 0;
        for (Constraint constraint : allConstraints) {
            IndexBasedConstraintConverter converter = constraint.getConverterFactory().create(this.model.getParameters());
            correspondingTupleLists.add(converter.convert(constraint, id++));
        }
        for (int i = 0; i < allConstraints.size(); ++i) {
            Constraint constraint;
            constraint = (Constraint)allConstraints.get(i);
            TupleList tupleList = (TupleList)correspondingTupleLists.get(i);
            this.constraintToTuplesListMap.put(constraint, tupleList);
            this.tuplesListToConstraintMap.put(tupleList, constraint);
        }
    }

    private CompleteTestModel createConvertedModel() {
        int[] parameterSizes = IntStream.range(0, this.model.size()).map(parameterId -> this.model.getParameters().get(parameterId).size()).toArray();
        Int2ObjectMap<List<PrimitiveSeed>> seeds = this.convertSeeds(this.model);
        Int2ObjectMap<List<PrimitiveStrengthGroup>> mixedStrengthGroups = this.convertMixedStrengthGroups(this.model);
        return CompleteTestModel.builder().positiveTestingStrength(this.model.getPositiveTestingStrength()).negativeTestingStrength(this.model.getNegativeTestingStrength()).parameterSizes(parameterSizes).exclusionTupleLists((Collection)this.model.getExclusionConstraints().stream().map(this.constraintToTuplesListMap::get).collect(Collectors.toSet())).errorTupleLists((Collection)this.model.getErrorConstraints().stream().map(this.constraintToTuplesListMap::get).collect(Collectors.toSet())).weights(this.convertWeights(this.model)).seeds(seeds).mixedStrengthGroups(mixedStrengthGroups).build();
    }

    private Int2ObjectMap<Int2DoubleMap> convertWeights(InputParameterModel model) {
        Int2ObjectOpenHashMap weights = new Int2ObjectOpenHashMap();
        for (Parameter parameter : model.getParameters()) {
            int parameterId = this.convertParameter(parameter);
            for (Value value : parameter.getValues()) {
                if (!value.hasWeight()) continue;
                int valueId = this.convertValue(parameter, value);
                ((Int2DoubleMap)weights.computeIfAbsent(parameterId, key -> new Int2DoubleOpenHashMap())).put(valueId, value.getRequiredWeight());
            }
        }
        return weights;
    }

    private Int2ObjectMap<List<PrimitiveSeed>> convertSeeds(InputParameterModel model) {
        Int2ObjectOpenHashMap seeds = new Int2ObjectOpenHashMap();
        seeds.put(-1, model.getPositiveSeeds().stream().map(this::convertSeed).collect(Collectors.toList()));
        for (Map.Entry<String, List<Seed>> errorConstraintSeeds : model.getNegativeSeeds().entrySet()) {
            int convertedConstraintId = this.findErrorConstraintIdByName(errorConstraintSeeds.getKey(), model);
            seeds.put(convertedConstraintId, errorConstraintSeeds.getValue().stream().map(this::convertSeed).collect(Collectors.toList()));
        }
        return seeds;
    }

    private PrimitiveSeed convertSeed(Seed seed) {
        int[] combination = this.convertCombination(seed.getCombination());
        return new PrimitiveSeed(combination, seed.getMode(), seed.getPriority());
    }

    private int findErrorConstraintIdByName(String constraintName, InputParameterModel model) {
        Constraint referencedErrorConstraint = model.getErrorConstraints().stream().filter(constraint -> constraint.getName().equals(constraintName)).findFirst().orElseThrow(() -> new IllegalStateException("Should not be able to reference non existing constraint"));
        return this.convertConstraint(referencedErrorConstraint).getId();
    }

    private Int2ObjectMap<List<PrimitiveStrengthGroup>> convertMixedStrengthGroups(InputParameterModel model) {
        Int2ObjectOpenHashMap mixedStrengthGroups = new Int2ObjectOpenHashMap();
        mixedStrengthGroups.put(-1, model.getPositiveMixedStrengthGroups().stream().map(this::convertMixedStrengthGroup).collect(Collectors.toList()));
        for (Constraint errorConstraint : model.getErrorConstraints()) {
            int constraintId = this.convertConstraint(errorConstraint).getId();
            StrengthGroup constraintGroup = StrengthGroup.mixedStrengthGroup(errorConstraint.getParameterNames()).ofHighestStrength().build(model.getParameters());
            mixedStrengthGroups.put(constraintId, List.of(this.convertMixedStrengthGroup(constraintGroup)));
        }
        return mixedStrengthGroups;
    }

    private PrimitiveStrengthGroup convertMixedStrengthGroup(StrengthGroup mixedStrengthGroup) {
        IntOpenHashSet parameterIds = new IntOpenHashSet(mixedStrengthGroup.getParameters().stream().mapToInt(this::convertParameter).toArray());
        return PrimitiveStrengthGroup.ofStrength((IntSet)parameterIds, (int)mixedStrengthGroup.getStrength());
    }

    @Override
    public InputParameterModel getModel() {
        return this.model;
    }

    @Override
    public CompleteTestModel getConvertedModel() {
        return this.convertedModel;
    }

    @Override
    public int[] convertCombination(Combination combination) {
        Preconditions.notNull((Object)combination);
        int[] combinationArray = CombinationUtil.emptyCombination((int)this.model.size());
        for (Map.Entry<Parameter, Value> mapping : combination.getParameterValueMap().entrySet()) {
            int valueId;
            int parameterId = this.parameterToIdMap.getInt((Object)mapping.getKey());
            combinationArray[parameterId] = valueId = this.parameterValueToIdMap.get(mapping.getKey()).getInt((Object)mapping.getValue());
        }
        return combinationArray;
    }

    @Override
    public Combination convertCombination(int[] combination) {
        Preconditions.notNull((Object)combination);
        Preconditions.check((combination.length == this.model.size() ? 1 : 0) != 0);
        HashMap<Parameter, Value> parameterValueMap = new HashMap<Parameter, Value>();
        for (int parameterId = 0; parameterId < this.model.size(); ++parameterId) {
            if (combination[parameterId] == -1) continue;
            Parameter parameter = this.model.getParameters().get(parameterId);
            Value correspondingValue = parameter.getValues().get(combination[parameterId]);
            parameterValueMap.put(parameter, correspondingValue);
        }
        return Combination.of(parameterValueMap);
    }

    @Override
    public int convertParameter(Parameter parameter) {
        Preconditions.notNull((Object)parameter);
        return this.parameterToIdMap.getInt((Object)parameter);
    }

    @Override
    public Parameter convertParameter(int parameter) {
        Preconditions.check((parameter >= 0 && parameter < this.model.size() ? 1 : 0) != 0);
        return this.model.getParameters().get(parameter);
    }

    @Override
    public int convertValue(Parameter parameter, Value value) {
        Preconditions.notNull((Object)parameter);
        Preconditions.notNull((Object)value);
        return this.parameterValueToIdMap.get(parameter).getInt((Object)value);
    }

    @Override
    public Value convertValue(int parameter, int value) {
        Preconditions.check((parameter >= 0 ? 1 : 0) != 0);
        Preconditions.check((value >= 0 ? 1 : 0) != 0);
        return this.model.getParameters().get(parameter).getValues().get(value);
    }

    @Override
    public TupleList convertConstraint(Constraint constraint) {
        Preconditions.notNull((Object)constraint);
        return this.constraintToTuplesListMap.get(constraint);
    }

    @Override
    public Constraint convertConstraint(TupleList constraint) {
        Preconditions.notNull((Object)constraint);
        return this.tuplesListToConstraintMap.get(constraint);
    }
}

