/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.converter.constraints;

import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Parameter;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.Constraint;
import de.rwth.swc.coffee4j.engine.converter.constraints.IndexBasedConstraintConverter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractIndexBasedConstraintConverter
implements IndexBasedConstraintConverter {
    private final Int2ObjectMap<Parameter> idToParameterMap;
    private final Object2IntMap<String> parameterNameIdMap;

    public AbstractIndexBasedConstraintConverter(List<Parameter> parameters) {
        Preconditions.notNull(parameters);
        this.idToParameterMap = this.constructIdToParameterMap(parameters);
        this.parameterNameIdMap = this.constructParameterNameMap(parameters);
    }

    @Override
    public List<TupleList> convert(List<Constraint> constraints, int lastId) {
        Preconditions.notNull(constraints);
        this.assertContainsOnlyValidParameters(constraints, (Collection<String>)this.parameterNameIdMap.keySet());
        ArrayList<TupleList> convertedConstraints = new ArrayList<TupleList>();
        for (Constraint constraint : constraints) {
            Preconditions.notNull((Object)constraint);
            convertedConstraints.add(this.convertedConstraint(constraint, this.parameterNameIdMap, this.idToParameterMap, ++lastId));
        }
        return convertedConstraints;
    }

    @Override
    public TupleList convert(Constraint constraint, int lastId) {
        Preconditions.notNull((Object)constraint);
        return this.convertedConstraint(constraint, this.parameterNameIdMap, this.idToParameterMap, ++lastId);
    }

    private Int2ObjectMap<Parameter> constructIdToParameterMap(List<Parameter> parameters) {
        Int2ObjectOpenHashMap newIdToParameterMap = new Int2ObjectOpenHashMap();
        for (int i = 0; i < parameters.size(); ++i) {
            newIdToParameterMap.put(i, (Object)parameters.get(i));
        }
        return newIdToParameterMap;
    }

    private Object2IntMap<String> constructParameterNameMap(List<Parameter> parameters) {
        Object2IntOpenHashMap parameterNameMap = new Object2IntOpenHashMap();
        for (int i = 0; i < parameters.size(); ++i) {
            parameterNameMap.put((Object)parameters.get(i).getName(), i);
        }
        return parameterNameMap;
    }

    private void assertContainsOnlyValidParameters(List<Constraint> constraints, Collection<String> parameterNames) {
        for (Constraint constraint : constraints) {
            Preconditions.check((boolean)parameterNames.containsAll(constraint.getParameterNames()));
        }
    }

    protected abstract TupleList convertedConstraint(Constraint var1, Object2IntMap<String> var2, Int2ObjectMap<Parameter> var3, int var4);
}

