/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.model.constraints.methodbased;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.AbstractConstraint;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.ConstraintStatus;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.methodbased.ConstraintFunction;
import de.rwth.swc.coffee4j.engine.converter.constraints.ConstraintConverterFactory;
import de.rwth.swc.coffee4j.engine.converter.constraints.methodbased.SimpleCartesianProductConstraintConverterFactory;
import java.util.List;
import java.util.stream.Collectors;

public class MethodBasedConstraint
extends AbstractConstraint {
    private final ConstraintFunction constraintFunction;

    public MethodBasedConstraint(String name, List<String> parameterNames, ConstraintFunction constraintFunction) {
        this(name, parameterNames, constraintFunction, ConstraintStatus.UNKNOWN);
    }

    public MethodBasedConstraint(String name, List<String> parameterNames, ConstraintFunction constraintFunction, ConstraintStatus constraintStatus) {
        super(name, parameterNames, constraintStatus);
        Preconditions.notNull((Object)constraintFunction);
        this.constraintFunction = constraintFunction;
    }

    @Override
    public boolean checkIfValid(Combination combination) {
        List input = this.getParameterNames().stream().map(combination::getRawValue).collect(Collectors.toList());
        try {
            return this.constraintFunction.check(input);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Could not call constraint \"" + this.getName() + "\" on parameters " + this.getParameterNames() + " with the given combination due to type issues. This most likely means that the constraint expects a different type than the actual value type of the constrained parameter.", e);
        }
    }

    @Override
    public ConstraintConverterFactory getConverterFactory() {
        return new SimpleCartesianProductConstraintConverterFactory();
    }

    public ConstraintFunction getConstraintFunction() {
        return this.constraintFunction;
    }
}

