/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.model.constraints;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.ConstraintStatus;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.methodbased.BooleanFunction1;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.methodbased.BooleanFunction2;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.methodbased.BooleanFunction3;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.methodbased.BooleanFunction4;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.methodbased.BooleanFunction5;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.methodbased.BooleanFunction6;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.methodbased.MethodBasedConstraint;
import java.util.Arrays;
import java.util.List;

public final class ConstraintBuilder {
    private ConstraintBuilder() {
    }

    private static List<String> toNonNullContainingList(String ... parameterNames) {
        Preconditions.notNull((Object)parameterNames);
        List<String> list = Arrays.asList(parameterNames);
        Preconditions.check((!list.contains(null) ? 1 : 0) != 0);
        return list;
    }

    public static Constraint1Builder constrain(String firstParameter) {
        return ConstraintBuilder.constrain(firstParameter, ConstraintStatus.UNKNOWN);
    }

    public static Constraint1Builder constrain(String firstParameter, ConstraintStatus constraintStatus) {
        return new Constraint1Builder(ConstraintBuilder.toNonNullContainingList(firstParameter), constraintStatus);
    }

    public static Constraint2Builder constrain(String firstParameter, String secondParameter) {
        return ConstraintBuilder.constrain(firstParameter, secondParameter, ConstraintStatus.UNKNOWN);
    }

    public static Constraint2Builder constrain(String firstParameter, String secondParameter, ConstraintStatus constraintStatus) {
        return new Constraint2Builder(ConstraintBuilder.toNonNullContainingList(firstParameter, secondParameter), constraintStatus);
    }

    public static Constraint3Builder constrain(String firstParameter, String secondParameter, String thirdParameter) {
        return ConstraintBuilder.constrain(firstParameter, secondParameter, thirdParameter, ConstraintStatus.UNKNOWN);
    }

    public static Constraint3Builder constrain(String firstParameter, String secondParameter, String thirdParameter, ConstraintStatus constraintStatus) {
        return new Constraint3Builder(ConstraintBuilder.toNonNullContainingList(firstParameter, secondParameter, thirdParameter), constraintStatus);
    }

    public static Constraint4Builder constrain(String firstParameter, String secondParameter, String thirdParameter, String fourthParameter) {
        return ConstraintBuilder.constrain(firstParameter, secondParameter, thirdParameter, fourthParameter, ConstraintStatus.UNKNOWN);
    }

    public static Constraint4Builder constrain(String firstParameter, String secondParameter, String thirdParameter, String fourthParameter, ConstraintStatus constraintStatus) {
        return new Constraint4Builder(ConstraintBuilder.toNonNullContainingList(firstParameter, secondParameter, thirdParameter, fourthParameter), constraintStatus);
    }

    public static Constraint5Builder constrain(String firstParameter, String secondParameter, String thirdParameter, String fourthParameter, String fifthParameter) {
        return ConstraintBuilder.constrain(firstParameter, secondParameter, thirdParameter, fourthParameter, fifthParameter, ConstraintStatus.UNKNOWN);
    }

    public static Constraint5Builder constrain(String firstParameter, String secondParameter, String thirdParameter, String fourthParameter, String fifthParameter, ConstraintStatus constraintStatus) {
        return new Constraint5Builder(ConstraintBuilder.toNonNullContainingList(firstParameter, secondParameter, thirdParameter, fourthParameter, fifthParameter), constraintStatus);
    }

    public static Constraint6Builder constrain(String firstParameter, String secondParameter, String thirdParameter, String fourthParameter, String fifthParameter, String sixthParameter) {
        return ConstraintBuilder.constrain(firstParameter, secondParameter, thirdParameter, fourthParameter, fifthParameter, sixthParameter, ConstraintStatus.UNKNOWN);
    }

    public static Constraint6Builder constrain(String firstParameter, String secondParameter, String thirdParameter, String fourthParameter, String fifthParameter, String sixthParameter, ConstraintStatus constraintStatus) {
        return new Constraint6Builder(ConstraintBuilder.toNonNullContainingList(firstParameter, secondParameter, thirdParameter, fourthParameter, fifthParameter, sixthParameter), constraintStatus);
    }

    public static final class Constraint6Builder {
        private String name = "";
        private final List<String> parameterNames;
        private final ConstraintStatus constraintStatus;

        private Constraint6Builder(List<String> parameterNames, ConstraintStatus constraintStatus) {
            this.parameterNames = parameterNames;
            this.constraintStatus = constraintStatus;
        }

        public Constraint6Builder withName(String name) {
            Preconditions.notNull((Object)name);
            this.name = name;
            return this;
        }

        public MethodBasedConstraint by(BooleanFunction6<?, ?, ?, ?, ?, ?> constraint) {
            Preconditions.notNull(constraint);
            return new MethodBasedConstraint(this.name, this.parameterNames, constraint, this.constraintStatus);
        }
    }

    public static final class Constraint5Builder {
        private String name = "";
        private final List<String> parameterNames;
        private final ConstraintStatus constraintStatus;

        private Constraint5Builder(List<String> parameterNames, ConstraintStatus constraintStatus) {
            this.parameterNames = parameterNames;
            this.constraintStatus = constraintStatus;
        }

        public Constraint5Builder withName(String name) {
            Preconditions.notNull((Object)name);
            this.name = name;
            return this;
        }

        public MethodBasedConstraint by(BooleanFunction5<?, ?, ?, ?, ?> constraint) {
            Preconditions.notNull(constraint);
            return new MethodBasedConstraint(this.name, this.parameterNames, constraint, this.constraintStatus);
        }
    }

    public static final class Constraint4Builder {
        private String name = "";
        private final List<String> parameterNames;
        private final ConstraintStatus constraintStatus;

        private Constraint4Builder(List<String> parameterNames, ConstraintStatus constraintStatus) {
            this.parameterNames = parameterNames;
            this.constraintStatus = constraintStatus;
        }

        public Constraint4Builder withName(String name) {
            Preconditions.notNull((Object)name);
            this.name = name;
            return this;
        }

        public MethodBasedConstraint by(BooleanFunction4<?, ?, ?, ?> constraint) {
            Preconditions.notNull(constraint);
            return new MethodBasedConstraint(this.name, this.parameterNames, constraint, this.constraintStatus);
        }
    }

    public static final class Constraint3Builder {
        private String name = "";
        private final List<String> parameterNames;
        private final ConstraintStatus constraintStatus;

        private Constraint3Builder(List<String> parameterNames, ConstraintStatus constraintStatus) {
            this.parameterNames = parameterNames;
            this.constraintStatus = constraintStatus;
        }

        public Constraint3Builder withName(String name) {
            Preconditions.notNull((Object)name);
            this.name = name;
            return this;
        }

        public MethodBasedConstraint by(BooleanFunction3<?, ?, ?> constraint) {
            Preconditions.notNull(constraint);
            return new MethodBasedConstraint(this.name, this.parameterNames, constraint, this.constraintStatus);
        }
    }

    public static final class Constraint2Builder {
        private String name = "";
        private final List<String> parameterNames;
        private final ConstraintStatus constraintStatus;

        private Constraint2Builder(List<String> parameterNames, ConstraintStatus constraintStatus) {
            this.parameterNames = parameterNames;
            this.constraintStatus = constraintStatus;
        }

        public Constraint2Builder withName(String name) {
            Preconditions.notNull((Object)name);
            this.name = name;
            return this;
        }

        public MethodBasedConstraint by(BooleanFunction2<?, ?> constraint) {
            Preconditions.notNull(constraint);
            return new MethodBasedConstraint(this.name, this.parameterNames, constraint, this.constraintStatus);
        }
    }

    public static final class Constraint1Builder {
        private String name = "";
        private final List<String> parameterNames;
        private final ConstraintStatus constraintStatus;

        private Constraint1Builder(List<String> parameterNames, ConstraintStatus constraintStatus) {
            this.parameterNames = parameterNames;
            this.constraintStatus = constraintStatus;
        }

        public Constraint1Builder withName(String name) {
            Preconditions.notNull((Object)name);
            this.name = name;
            return this;
        }

        public MethodBasedConstraint by(BooleanFunction1<?> constraint) {
            Preconditions.notNull(constraint);
            return new MethodBasedConstraint(this.name, this.parameterNames, constraint, this.constraintStatus);
        }
    }
}

