/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.model;

import de.rwth.swc.coffee4j.algorithmic.model.SeedMode;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.Parameter;
import java.util.Collection;
import java.util.Map;

public class Seed {
    public static final double NO_PRIORITY = 0.0;
    private final Combination combination;
    private final SeedMode mode;
    private final double priority;

    private Seed(Builder builder) {
        Preconditions.notNull((Object)builder.combination, (String)"combination required");
        Preconditions.notNull((Object)builder.mode, (String)"mode required");
        this.combination = builder.combination;
        this.mode = builder.mode;
        this.priority = builder.priority;
    }

    public Combination getCombination() {
        return this.combination;
    }

    public SeedMode getMode() {
        return this.mode;
    }

    public double getPriority() {
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != 0.0;
    }

    public static Builder seed(Combination combination) {
        Preconditions.notNull((Object)combination, (String)"combination required");
        return new Builder(combination);
    }

    @SafeVarargs
    public static Builder seed(Map.Entry<String, Object> ... entries) {
        return new Builder(Combination.combination(entries));
    }

    @SafeVarargs
    public static Builder suspiciousSeed(Map.Entry<String, Object> ... entries) {
        return Seed.seed(entries).mode(SeedMode.EXCLUSIVE);
    }

    public static final class Builder {
        private Combination combination;
        private Combination.Builder combinationBuilder;
        private SeedMode mode = SeedMode.NON_EXCLUSIVE;
        private double priority = 0.0;

        private Builder(Combination.Builder combinationBuilder) {
            this.combinationBuilder = combinationBuilder;
        }

        private Builder(Combination combination) {
            this.combination = combination;
        }

        public Builder mode(SeedMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder suspicious() {
            return this.mode(SeedMode.EXCLUSIVE);
        }

        public Builder priority(double priority) {
            this.priority = priority;
            return this;
        }

        public Seed build(Collection<Parameter> parameters) {
            if (this.combination == null) {
                if (this.combinationBuilder == null) {
                    throw new IllegalStateException("It should not be possible for both combination and combinationBuilder to be null.");
                }
                this.combination = this.combinationBuilder.build(parameters);
            }
            return new Seed(this);
        }
    }
}

