/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.model;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Parameter;
import de.rwth.swc.coffee4j.engine.configuration.model.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Combination {
    private static final Combination EMPTY_COMBINATION = new Combination(Map.of());
    private final Map<Parameter, Value> parameterValueMap;

    private Combination(Map<Parameter, Value> parameterValueMap) {
        Preconditions.notNull(parameterValueMap);
        Combination.assertValidValues(parameterValueMap);
        this.parameterValueMap = new HashMap<Parameter, Value>(parameterValueMap);
    }

    public static Combination of(Map<Parameter, Value> parameterValueMap) {
        return new Combination(parameterValueMap);
    }

    public static Combination empty() {
        return EMPTY_COMBINATION;
    }

    private static void assertValidValues(Map<Parameter, Value> parameterValueMap) {
        for (Map.Entry<Parameter, Value> mapping : parameterValueMap.entrySet()) {
            Preconditions.notNull((Object)mapping.getKey());
            Preconditions.notNull((Object)mapping.getValue());
            Preconditions.check((boolean)mapping.getKey().getValues().contains(mapping.getValue()));
        }
    }

    public Value getValue(Parameter parameter) {
        return this.parameterValueMap.get(parameter);
    }

    public Value getValue(String parameterName) {
        for (Map.Entry<Parameter, Value> mapping : this.parameterValueMap.entrySet()) {
            if (!mapping.getKey().getName().equals(parameterName)) continue;
            return mapping.getValue();
        }
        return null;
    }

    public Object getRawValue(Parameter parameter) {
        Preconditions.check((boolean)this.parameterValueMap.containsKey(parameter));
        return this.parameterValueMap.get(parameter).get();
    }

    public Object getRawValue(String parameterName) {
        for (Map.Entry<Parameter, Value> mapping : this.parameterValueMap.entrySet()) {
            if (!mapping.getKey().getName().equals(parameterName)) continue;
            return mapping.getValue().get();
        }
        throw new IllegalArgumentException("There is no parameter with name \"" + parameterName + "\"");
    }

    public Map<Parameter, Value> getParameterValueMap() {
        return Collections.unmodifiableMap(this.parameterValueMap);
    }

    public int size() {
        return this.parameterValueMap.size();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Combination other = (Combination)object;
        return Objects.equals(this.parameterValueMap, other.parameterValueMap);
    }

    public int hashCode() {
        return Objects.hash(this.parameterValueMap);
    }

    public String toString() {
        return "[" + this.parameterValueMap.entrySet().stream().map(entry -> ((Parameter)entry.getKey()).getName() + "=" + ((Value)entry.getValue()).toString()).collect(Collectors.joining(", ")) + "]";
    }

    public boolean contains(Combination otherCombination) {
        Preconditions.notNull((Object)otherCombination);
        for (Map.Entry<Parameter, Value> otherEntry : otherCombination.parameterValueMap.entrySet()) {
            Value value = this.parameterValueMap.get(otherEntry.getKey());
            if (value == null) {
                return false;
            }
            Value otherValue = otherEntry.getValue();
            if (value.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static Builder combination(Map.Entry<String, Object> ... entries) {
        Preconditions.notNull(entries);
        return new Builder(List.of(entries));
    }

    public static final class Builder {
        private final List<Map.Entry<String, Object>> entries;

        private Builder(Collection<Map.Entry<String, Object>> entries) {
            this.entries = new ArrayList<Map.Entry<String, Object>>(entries);
        }

        public Combination build(Collection<Parameter> parameters) {
            HashMap<Parameter, Value> parameterValueMap = new HashMap<Parameter, Value>(this.entries.size());
            for (Map.Entry<String, Object> entry : this.entries) {
                Parameter parameter = this.findParameterByName(entry.getKey(), parameters);
                Value value = this.findValueByData(entry.getValue(), parameter);
                parameterValueMap.put(parameter, value);
            }
            return Combination.of(parameterValueMap);
        }

        private Parameter findParameterByName(String parameterName, Collection<Parameter> parameters) {
            return parameters.stream().filter(parameter -> parameter.getName().equals(parameterName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find parameter with name " + parameterName + " in parameters " + parameters));
        }

        private Value findValueByData(Object data, Parameter parameter) {
            return parameter.getValues().stream().filter(value -> Objects.equals(value.get(), data)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find value " + data + " in parameter " + parameter));
        }
    }
}

