/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.execution.TestInputExecutor;
import de.rwth.swc.coffee4j.engine.configuration.model.InputParameterModel;

public class TestMethodConfiguration {
    private final InputParameterModel inputParameterModel;
    private final TestInputExecutor testInputExecutor;

    private TestMethodConfiguration(Builder builder) {
        Preconditions.notNull((Object)builder.testExecutor);
        this.inputParameterModel = (InputParameterModel)Preconditions.notNull((Object)builder.inputParameterModel);
        this.testInputExecutor = (TestInputExecutor)Preconditions.notNull((Object)builder.testExecutor);
    }

    public InputParameterModel getInputParameterModel() {
        return this.inputParameterModel;
    }

    public TestInputExecutor getTestInputExecutor() {
        return this.testInputExecutor;
    }

    public Builder toBuilder() {
        return TestMethodConfiguration.testMethodConfiguration().inputParameterModel(this.inputParameterModel).testExecutor(this.testInputExecutor);
    }

    public static Builder testMethodConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private InputParameterModel inputParameterModel;
        private TestInputExecutor testExecutor;

        public Builder inputParameterModel(InputParameterModel inputParameterModel) {
            this.inputParameterModel = inputParameterModel;
            return this;
        }

        public Builder testExecutor(TestInputExecutor testExecutor) {
            this.testExecutor = testExecutor;
            return this;
        }

        public TestMethodConfiguration build() {
            return new TestMethodConfiguration(this);
        }
    }
}

