package de.rwth.swc.coffee4j.engine.manager;

import de.rwth.swc.coffee4j.engine.TestResult;
import de.rwth.swc.coffee4j.engine.constraint.diagnosis.InternalConflict;

import java.util.List;

/**
 * Defines a manager which can completely manage a combinatorial test including dynamic test generation (e.g
 * fault characterization).
 */
public interface CombinatorialTestManager {

    List<InternalConflict> checkConstraintsForConflicts();

    /**
     * Generates all initial test inputs for execution. This should generate at least one test input if dynamic generation
     * via {@link #generateAdditionalTestInputsWithResult(int[], TestResult)} should be used, as most front-ends won't
     * call {@link #generateAdditionalTestInputsWithResult(int[], TestResult)} if this returned no test input.
     *
     * @return a list of all initial test inputs. It is not guaranteed that these test inputs don't contain duplicates
     */
    List<int[]> generateInitialTests();
    
    /**
     * Generates additional test inputs based on results of previous test inputs normally generated by either
     * {@link #generateInitialTests()} or this method in a previous iteration. For example, this functionality can be
     * used to implement dynamic test input generation or fault characterization (or a combination of both).
     *
     * @param testInput  the test input for which's result further test inputs should be generated
     * @param testResult the result of the test input
     * @return a list of additional test inputs generated based on the result of the given test inputs. This does not
     * necessarily have to return any test inputs for each call
     */
    List<int[]> generateAdditionalTestInputsWithResult(int[] testInput, TestResult testResult);
    
}
