/*
 * Decompiled with CFR 0.152.
 */
package jmhBenchmarkHelper;

import de.rwth.i2.attestor.main.Attestor;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public class BenchmarkHelper {
    private static boolean CHECK_EXPECTED_SIZE = System.getProperty("attestor.checkExpectedSize").equalsIgnoreCase("true");
    private static final Path file = Paths.get("benchmark-results.csv", new String[0]);
    private boolean checkLTLResults;
    private boolean expectedLTLResults;
    private boolean checkTotalStates;
    private long expectedTotalStates;
    private boolean checkMainProcedureStates;
    private long expectedMainProcedureStates;
    private boolean checkFinalStates;
    private long expectedFinalStates;
    private boolean checkCounterexampleNumber;
    private int expectedCounterexampleNumber;
    private boolean expectFatal = false;
    private boolean autosetRootPath = true;
    private String rootPath;
    private StringBuilder errorBuilder = new StringBuilder();

    BenchmarkHelper() {
    }

    public static BenchmarkHelperBuilder builder() {
        return new BenchmarkHelperBuilder();
    }

    public void run() {
        String errorMessage;
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        String methodName = stackTraceElement.getMethodName();
        if (this.autosetRootPath) {
            String className = stackTraceElement.getClassName();
            className = className.substring(className.lastIndexOf(".") + 1);
            this.rootPath = "./" + className;
        }
        Attestor attestor = new Attestor();
        attestor.run(new String[]{"-rp", this.rootPath, "-sf", "configuration/settings/" + methodName + ".json"});
        if (!CHECK_EXPECTED_SIZE) {
            return;
        }
        if (this.checkTotalStates) {
            this.failOnMismatch(attestor.getTotalNumberOfStates(), this.expectedTotalStates, "Total number of states does not match.");
        }
        if (this.checkMainProcedureStates) {
            this.failOnMismatch((long)attestor.getNumberOfStatesWithoutProcedureCalls(), this.expectedMainProcedureStates, "Number of states without procedure calls does not match.");
        }
        if (this.checkFinalStates) {
            this.failOnMismatch((long)attestor.getNumberOfFinalStates(), this.expectedFinalStates, "Number of final states does not match.");
        }
        if (this.checkLTLResults) {
            this.failOnMismatch(attestor.hasAllLTLSatisfied(), this.expectedLTLResults, "Model-checking results do not match (SAT=true, UNSAT=false).");
        }
        if (this.checkCounterexampleNumber) {
            this.failOnMismatch(attestor.getCounterexamples().size(), this.expectedCounterexampleNumber, "Number of generated counterexamples does not match.");
        }
        if (this.expectFatal) {
            this.failOnMismatch(attestor.hasFatalError(), this.expectFatal, "Expected fatal error, e.g. a detected null pointer dereference.");
        }
        if (!(errorMessage = this.errorBuilder.toString()).isEmpty()) {
            throw new IllegalStateException("\n" + errorMessage);
        }
        this.logResults(attestor);
    }

    private void failOnMismatch(long actual, long expected, String message) {
        if (actual != expected) {
            this.storeFailure(actual, expected, message);
        }
    }

    private void failOnMismatch(int actual, int expected, String message) {
        if (actual != expected) {
            this.storeFailure(actual, expected, message);
        }
    }

    private void failOnMismatch(boolean actual, boolean expected, String message) {
        if (actual != expected) {
            this.storeFailure(actual, expected, message);
        }
    }

    private void logResults(Attestor attestor) {
        try {
            StringBuilder lineBuilder = new StringBuilder();
            lineBuilder.append(attestor.getInputName()).append(",").append(attestor.getSpecificationDescription()).append(",").append(attestor.getTotalNumberOfStates()).append(",");
            Map executionTimes = attestor.getExecutionTimes();
            lineBuilder.append(String.format(Locale.ROOT, "%.3f", executionTimes.get("Interprocedural Analysis"))).append(",").append(String.format(Locale.ROOT, "%.3f", executionTimes.get("Model checking"))).append(",").append(String.format(Locale.ROOT, "%.3f", executionTimes.get("Verification"))).append(",").append(String.format(Locale.ROOT, "%.3f", executionTimes.get("Total")));
            Files.write(file, Collections.singletonList(lineBuilder.toString()), Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private <T> void storeFailure(T actual, T expected, String message) {
        this.errorBuilder.append(message);
        this.errorBuilder.append("\n");
        this.errorBuilder.append("Expected: ");
        this.errorBuilder.append(expected);
        this.errorBuilder.append("\n");
        this.errorBuilder.append("Got: ");
        this.errorBuilder.append(actual);
        this.errorBuilder.append("\n------------------------------------------------\n");
    }

    public static class BenchmarkHelperBuilder {
        private BenchmarkHelper benchmarkHelper = new BenchmarkHelper();

        public BenchmarkHelper build() {
            BenchmarkHelper result = this.benchmarkHelper;
            this.benchmarkHelper = null;
            return result;
        }

        public BenchmarkHelperBuilder expectLTLResults(boolean allSatisfied) {
            this.benchmarkHelper.checkLTLResults = true;
            this.benchmarkHelper.expectedLTLResults = allSatisfied;
            return this;
        }

        public BenchmarkHelperBuilder expectTotalStates(long totalStates) {
            this.benchmarkHelper.checkTotalStates = true;
            this.benchmarkHelper.expectedTotalStates = totalStates;
            return this;
        }

        public BenchmarkHelperBuilder expectMainProcedureStates(long mainProcedureStates) {
            this.benchmarkHelper.checkMainProcedureStates = true;
            this.benchmarkHelper.expectedMainProcedureStates = mainProcedureStates;
            return this;
        }

        public BenchmarkHelperBuilder expectFinalStates(long finalStates) {
            this.benchmarkHelper.checkFinalStates = true;
            this.benchmarkHelper.expectedFinalStates = finalStates;
            return this;
        }

        public BenchmarkHelperBuilder expectNoCounterexamples(int noCounterexamples) {
            this.benchmarkHelper.checkCounterexampleNumber = true;
            this.benchmarkHelper.expectedCounterexampleNumber = noCounterexamples;
            return this;
        }

        public BenchmarkHelperBuilder setRootPath(String rootPath) {
            this.benchmarkHelper.autosetRootPath = false;
            this.benchmarkHelper.rootPath = rootPath;
            return this;
        }

        public BenchmarkHelperBuilder expectFatal() {
            this.benchmarkHelper.expectFatal = true;
            return this;
        }
    }
}

