/*
 * Decompiled with CFR 0.152.
 */
package jmhBenchmarkHelper;

import de.rwth.i2.attestor.main.Attestor;

public class BenchmarkHelper {
    private static boolean CHECK_EXPECTED_SIZE = System.getProperty("attestor.checkExpectedSize").equalsIgnoreCase("true");
    private boolean checkLTLResults;
    private boolean expectedLTLResults;
    private boolean checkTotalStates;
    private long expectedTotalStates;
    private boolean checkMainProcedureStates;
    private long expectedMainProcedureStates;
    private boolean checkFinalStates;
    private long expectedFinalStates;
    private boolean checkCounterexampleNumber;
    private int expectedCounterexampleNumber;
    private boolean autosetRootPath = true;
    private String rootPath;
    private StringBuilder errorBuilder = new StringBuilder();

    BenchmarkHelper() {
    }

    public static BenchmarkHelperBuilder builder() {
        return new BenchmarkHelperBuilder();
    }

    public void run() {
        String errorMessage;
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        String methodName = stackTraceElement.getMethodName();
        if (this.autosetRootPath) {
            String className = stackTraceElement.getClassName();
            className = className.substring(className.lastIndexOf(".") + 1);
            this.rootPath = "./" + className;
        }
        Attestor attestor = new Attestor();
        attestor.run(new String[]{"-rp", this.rootPath, "-sf", "configuration/settings/" + methodName + ".json"});
        if (!CHECK_EXPECTED_SIZE) {
            return;
        }
        if (this.checkTotalStates) {
            this.failOnMismatch(attestor.getTotalNumberOfStates(), this.expectedTotalStates, "Total number of states does not match.");
        }
        if (this.checkMainProcedureStates) {
            this.failOnMismatch((long)attestor.getNumberOfStatesWithoutProcedureCalls(), this.expectedMainProcedureStates, "Number of states without procedure calls does not match.");
        }
        if (this.checkFinalStates) {
            this.failOnMismatch((long)attestor.getNumberOfFinalStates(), this.expectedFinalStates, "Number of final states does not match.");
        }
        if (this.checkLTLResults) {
            this.failOnMismatch(attestor.hasAllLTLSatisfied(), this.expectedLTLResults, "Model-checking results do not match (SAT=true, UNSAT=false).");
        }
        if (this.checkCounterexampleNumber) {
            this.failOnMismatch(attestor.getCounterexamples().size(), this.expectedCounterexampleNumber, "Number of generated counterexamples does not match.");
        }
        if (!(errorMessage = this.errorBuilder.toString()).isEmpty()) {
            throw new IllegalStateException("\n" + errorMessage);
        }
    }

    private void failOnMismatch(long actual, long expected, String message) {
        if (actual != expected) {
            this.storeFailure(actual, expected, message);
        }
    }

    private void failOnMismatch(int actual, int expected, String message) {
        if (actual != expected) {
            this.storeFailure(actual, expected, message);
        }
    }

    private void failOnMismatch(boolean actual, boolean expected, String message) {
        if (actual != expected) {
            this.storeFailure(actual, expected, message);
        }
    }

    private <T> void storeFailure(T actual, T expected, String message) {
        this.errorBuilder.append(message);
        this.errorBuilder.append("\n");
        this.errorBuilder.append("Expected: ");
        this.errorBuilder.append(expected);
        this.errorBuilder.append("\n");
        this.errorBuilder.append("Got: ");
        this.errorBuilder.append(actual);
        this.errorBuilder.append("\n------------------------------------------------\n");
    }

    public static class BenchmarkHelperBuilder {
        private BenchmarkHelper benchmarkHelper = new BenchmarkHelper();

        public BenchmarkHelper build() {
            BenchmarkHelper result = this.benchmarkHelper;
            this.benchmarkHelper = null;
            return result;
        }

        public BenchmarkHelperBuilder expectLTLResults(boolean allSatisfied) {
            this.benchmarkHelper.checkLTLResults = true;
            this.benchmarkHelper.expectedLTLResults = allSatisfied;
            return this;
        }

        public BenchmarkHelperBuilder expectTotalStates(long totalStates) {
            this.benchmarkHelper.checkTotalStates = true;
            this.benchmarkHelper.expectedTotalStates = totalStates;
            return this;
        }

        public BenchmarkHelperBuilder expectMainProcedureStates(long mainProcedureStates) {
            this.benchmarkHelper.checkMainProcedureStates = true;
            this.benchmarkHelper.expectedMainProcedureStates = mainProcedureStates;
            return this;
        }

        public BenchmarkHelperBuilder expectFinalStates(long finalStates) {
            this.benchmarkHelper.checkFinalStates = true;
            this.benchmarkHelper.expectedFinalStates = finalStates;
            return this;
        }

        public BenchmarkHelperBuilder expectNoCounterexamples(int noCounterexamples) {
            this.benchmarkHelper.checkCounterexampleNumber = true;
            this.benchmarkHelper.expectedCounterexampleNumber = noCounterexamples;
            return this;
        }

        public BenchmarkHelperBuilder setRootPath(String rootPath) {
            this.benchmarkHelper.autosetRootPath = false;
            this.benchmarkHelper.rootPath = rootPath;
            return this;
        }
    }
}

