/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.i2.attestor;

import de.rwth.i2.attestor.generated.analysis.DepthFirstAdapter;
import de.rwth.i2.attestor.generated.node.AAndStateform;
import de.rwth.i2.attestor.generated.node.ANegStateform;
import de.rwth.i2.attestor.generated.node.ANextLtlform;
import de.rwth.i2.attestor.generated.node.AOrStateform;
import de.rwth.i2.attestor.generated.node.AReleaseLtlform;
import de.rwth.i2.attestor.generated.node.AStateformLtlform;
import de.rwth.i2.attestor.generated.node.AUntilLtlform;
import de.rwth.i2.attestor.generated.node.Node;
import de.rwth.i2.attestor.generated.node.PLtlform;
import de.rwth.i2.attestor.generated.node.PStateform;
import de.rwth.i2.attestor.generated.node.TAnd;
import de.rwth.i2.attestor.generated.node.TLparen;
import de.rwth.i2.attestor.generated.node.TNeg;
import de.rwth.i2.attestor.generated.node.TNext;
import de.rwth.i2.attestor.generated.node.TOr;
import de.rwth.i2.attestor.generated.node.TRelease;
import de.rwth.i2.attestor.generated.node.TRparen;
import de.rwth.i2.attestor.generated.node.TUntil;

public class NegationPusher
extends DepthFirstAdapter {
    @Override
    public void caseAStateformLtlform(AStateformLtlform node) {
        PStateform stateForm = node.getStateform();
        if (stateForm instanceof ANegStateform) {
            Node newNode;
            PLtlform nonNegForm = ((ANegStateform)stateForm).getLtlform();
            if (nonNegForm != (newNode = this.handlePushCases(nonNegForm))) {
                node.replaceBy(newNode);
                newNode.apply(this);
            }
        } else {
            super.caseAStateformLtlform(node);
        }
    }

    private Node handlePushCases(Node nonNegForm) {
        if (nonNegForm instanceof AStateformLtlform && ((AStateformLtlform)nonNegForm).getStateform() instanceof ANegStateform) {
            return ((ANegStateform)((AStateformLtlform)nonNegForm).getStateform()).getLtlform();
        }
        if (nonNegForm instanceof AStateformLtlform && ((AStateformLtlform)nonNegForm).getStateform() instanceof AOrStateform) {
            AOrStateform orForm = (AOrStateform)((AStateformLtlform)nonNegForm).getStateform();
            PLtlform form1 = orForm.getLeftform();
            PLtlform form2 = orForm.getRightform();
            AStateformLtlform negForm1Ltl = new AStateformLtlform(new ANegStateform(new TNeg(), form1));
            AStateformLtlform negForm2Ltl = new AStateformLtlform(new ANegStateform(new TNeg(), form2));
            AStateformLtlform andFormLtl = new AStateformLtlform(new AAndStateform(new TLparen(), negForm1Ltl, new TAnd(), negForm2Ltl, new TRparen()));
            return andFormLtl;
        }
        if (nonNegForm instanceof AStateformLtlform && ((AStateformLtlform)nonNegForm).getStateform() instanceof AAndStateform) {
            AAndStateform andForm = (AAndStateform)((AStateformLtlform)nonNegForm).getStateform();
            PLtlform form1 = andForm.getLeftform();
            PLtlform form2 = andForm.getRightform();
            AStateformLtlform negForm1Ltl = new AStateformLtlform(new ANegStateform(new TNeg(), form1));
            AStateformLtlform negForm2Ltl = new AStateformLtlform(new ANegStateform(new TNeg(), form2));
            AStateformLtlform orFormLtl = new AStateformLtlform(new AOrStateform(new TLparen(), negForm1Ltl, new TOr(), negForm2Ltl, new TRparen()));
            return orFormLtl;
        }
        if (nonNegForm instanceof ANextLtlform) {
            PLtlform form = ((ANextLtlform)nonNegForm).getLtlform();
            AStateformLtlform negForm = new AStateformLtlform(new ANegStateform(new TNeg(), form));
            ANextLtlform nextLtlform = new ANextLtlform(new TNext(), negForm);
            return nextLtlform;
        }
        if (nonNegForm instanceof AUntilLtlform) {
            PLtlform form1 = ((AUntilLtlform)nonNegForm).getLeftform();
            PLtlform form2 = ((AUntilLtlform)nonNegForm).getRightform();
            AStateformLtlform negForm1Ltl = new AStateformLtlform(new ANegStateform(new TNeg(), form1));
            AStateformLtlform negForm2Ltl = new AStateformLtlform(new ANegStateform(new TNeg(), form2));
            AReleaseLtlform releaseForm = new AReleaseLtlform(new TLparen(), negForm1Ltl, new TRelease(), negForm2Ltl, new TRparen());
            return releaseForm;
        }
        if (nonNegForm instanceof AReleaseLtlform) {
            PLtlform form1 = ((AReleaseLtlform)nonNegForm).getLeftform();
            PLtlform form2 = ((AReleaseLtlform)nonNegForm).getRightform();
            AStateformLtlform negForm1Ltl = new AStateformLtlform(new ANegStateform(new TNeg(), form1));
            AStateformLtlform negForm2Ltl = new AStateformLtlform(new ANegStateform(new TNeg(), form2));
            AUntilLtlform untilForm = new AUntilLtlform(new TLparen(), negForm1Ltl, new TUntil(), negForm2Ltl, new TRparen());
            return untilForm;
        }
        return nonNegForm;
    }
}

