/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.i2.attestor;

import de.rwth.i2.attestor.APCollector;
import de.rwth.i2.attestor.FormulaWalker;
import de.rwth.i2.attestor.NegationPusher;
import de.rwth.i2.attestor.OperatorEliminator;
import de.rwth.i2.attestor.generated.lexer.Lexer;
import de.rwth.i2.attestor.generated.lexer.LexerException;
import de.rwth.i2.attestor.generated.node.Node;
import de.rwth.i2.attestor.generated.node.Start;
import de.rwth.i2.attestor.generated.parser.Parser;
import de.rwth.i2.attestor.generated.parser.ParserException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class LTLFormula {
    private String formulaString;
    private Start SableCCast;
    private List<String> apList;
    private FormulaWalker walker;

    public LTLFormula(String formula) throws ParserException, LexerException, IOException {
        this.formulaString = formula;
        this.walker = new FormulaWalker();
        Lexer lexer = new Lexer(new PushbackReader(new StringReader(this.formulaString), 1024));
        Parser parser = new Parser(lexer);
        this.SableCCast = parser.parse();
        APCollector apCollector = new APCollector();
        this.SableCCast.apply(apCollector);
        this.apList = apCollector.getAps();
    }

    public ArrayList<Node> getTableauSubformulae(Node node) {
        this.walker.resetSuccessors();
        node.apply(this.walker);
        return this.walker.getSuccessors();
    }

    public List<String> getApList() {
        return this.apList;
    }

    public String toString() {
        return this.SableCCast.toString();
    }

    public Start getASTRoot() {
        return this.SableCCast;
    }

    public FormulaWalker getFormulaWalker() {
        return this.walker;
    }

    public String getFormulaString() {
        return this.formulaString;
    }

    public boolean equals(LTLFormula formula) {
        return this.formulaString.replaceAll(" ", "") == formula.getFormulaString().replaceAll(" ", "");
    }

    public int hashCode() {
        return this.formulaString.replaceAll(" ", "").hashCode();
    }

    public void toPNF() {
        OperatorEliminator operatorEliminator = new OperatorEliminator();
        this.SableCCast.apply(operatorEliminator);
        NegationPusher negPusher = new NegationPusher();
        this.SableCCast.apply(negPusher);
    }
}

