/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.i2.attestor;

import com.google.common.collect.HashBiMap;
import de.rwth.i2.attestor.generated.analysis.AnalysisAdapter;
import de.rwth.i2.attestor.generated.node.AAndStateform;
import de.rwth.i2.attestor.generated.node.AAtomicpropTerm;
import de.rwth.i2.attestor.generated.node.AFalseTerm;
import de.rwth.i2.attestor.generated.node.ANegStateform;
import de.rwth.i2.attestor.generated.node.ANextLtlform;
import de.rwth.i2.attestor.generated.node.AOrStateform;
import de.rwth.i2.attestor.generated.node.AStateformLtlform;
import de.rwth.i2.attestor.generated.node.ATermLtlform;
import de.rwth.i2.attestor.generated.node.ATrueTerm;
import de.rwth.i2.attestor.generated.node.AUntilLtlform;
import de.rwth.i2.attestor.generated.node.Node;
import de.rwth.i2.attestor.generated.node.Start;
import de.rwth.i2.attestor.generated.node.TNext;
import java.util.ArrayList;

public class FormulaWalker
extends AnalysisAdapter {
    HashBiMap<Node, ANextLtlform> additionalNextFormulae = HashBiMap.create();
    ArrayList<Node> successors = new ArrayList();

    @Override
    public void caseStart(Start node) {
        node.getPLtlform().apply(this);
    }

    @Override
    public void caseAStateformLtlform(AStateformLtlform node) {
        if (node.getStateform() != null) {
            node.getStateform().apply(this);
        }
    }

    @Override
    public void caseANextLtlform(ANextLtlform node) {
        if (this.additionalNextFormulae.containsValue((Object)node)) {
            this.successors.add((Node)this.additionalNextFormulae.inverse().get((Object)node));
        } else if (node.getLtlform() != null) {
            this.successors.add(node.getLtlform());
        }
    }

    @Override
    public void caseATermLtlform(ATermLtlform node) {
        if (node.getTerm() != null) {
            node.getTerm().apply(this);
        }
    }

    @Override
    public void caseAUntilLtlform(AUntilLtlform node) {
        ANextLtlform nextNode;
        if (node.getLeftform() != null) {
            this.successors.add(node.getLeftform());
        }
        if (node.getRightform() != null) {
            this.successors.add(node.getRightform());
        }
        if (this.additionalNextFormulae.containsKey((Object)node)) {
            nextNode = (ANextLtlform)this.additionalNextFormulae.get((Object)node);
        } else {
            TNext nextToken = new TNext();
            AUntilLtlform helperNode = new AUntilLtlform();
            nextNode = new ANextLtlform(nextToken, helperNode);
            this.additionalNextFormulae.put((Object)node, (Object)nextNode);
        }
        this.successors.add(nextNode);
    }

    public void caseAReleaseLtlform(AUntilLtlform node) {
        ANextLtlform nextNode;
        if (node.getLeftform() != null) {
            this.successors.add(node.getLeftform());
        }
        if (node.getRightform() != null) {
            this.successors.add(node.getRightform());
        }
        if (this.additionalNextFormulae.containsKey((Object)node)) {
            nextNode = (ANextLtlform)this.additionalNextFormulae.get((Object)node);
        } else {
            TNext nextToken = new TNext();
            AUntilLtlform helperNode = new AUntilLtlform();
            nextNode = new ANextLtlform(nextToken, helperNode);
            this.additionalNextFormulae.put((Object)node, (Object)nextNode);
        }
        this.successors.add(nextNode);
    }

    @Override
    public void caseANegStateform(ANegStateform node) {
        this.successors.add(node);
    }

    @Override
    public void caseAAndStateform(AAndStateform node) {
        if (node.getLeftform() != null) {
            this.successors.add(node.getLeftform());
        }
        if (node.getRightform() != null) {
            this.successors.add(node.getRightform());
        }
    }

    @Override
    public void caseAOrStateform(AOrStateform node) {
        if (node.getLeftform() != null) {
            this.successors.add(node.getLeftform());
        }
        if (node.getRightform() != null) {
            this.successors.add(node.getRightform());
        }
    }

    @Override
    public void caseATrueTerm(ATrueTerm node) {
        this.successors.add(node);
    }

    @Override
    public void caseAFalseTerm(AFalseTerm node) {
        this.successors.add(node);
    }

    @Override
    public void caseAAtomicpropTerm(AAtomicpropTerm node) {
        this.successors.add(node);
    }

    public HashBiMap<Node, ANextLtlform> getAdditionalNextFormulae() {
        return this.additionalNextFormulae;
    }

    public void resetSuccessors() {
        this.successors = new ArrayList();
    }

    public ArrayList<Node> getSuccessors() {
        return this.successors;
    }
}

