/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.template;

import de.ruedigermoeller.template.IContextReceiver;
import de.ruedigermoeller.template.TemplateExecutionException;
import de.ruedigermoeller.template.TemplateSplitter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class TemplateExecutor {
    File templateFile;
    File outputFile = new File("gen");
    Object context;
    String tmpDir = "tempgen";
    public boolean sysout = false;

    public static int Run(String outputFile, String templateFile, Object context) {
        TemplateExecutor exec = new TemplateExecutor(new File(templateFile), new File(outputFile), context);
        boolean res = false;
        try {
            res = exec.execute(System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res ? -1 : 1;
    }

    public static int Run(String templateFile, Object context) {
        return TemplateExecutor.Run("gen", templateFile, context);
    }

    public TemplateExecutor() {
    }

    public void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public TemplateExecutor(File templateFile, File outputFile, Object context) {
        this.setFiles(templateFile, outputFile, context);
    }

    String getNameWithoutExt(File f) {
        String fil = f.getName();
        if (fil.lastIndexOf(46) >= 0) {
            return fil.substring(0, fil.lastIndexOf(46));
        }
        return fil;
    }

    public void setFiles(File templateFile, File outputFile, Object context) {
        this.templateFile = templateFile;
        this.outputFile = outputFile;
        this.context = context;
    }

    public boolean execute() throws Exception {
        return this.execute(null);
    }

    public void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public boolean execute(PrintStream output) throws Exception {
        File tempFile = new File(this.tmpDir);
        MyCL myCl = new MyCL();
        if (!tempFile.exists()) {
            tempFile.mkdir();
        }
        if (!tempFile.exists() || !tempFile.isDirectory()) {
            throw new TemplateExecutionException("Could not create temporary directory, aborting. (" + tempFile.getAbsolutePath() + ")");
        }
        try {
            String resultClassName = this.getNameWithoutExt(this.outputFile);
            String className = this.getNameWithoutExt(this.templateFile) + "GEN";
            File clazzFile = new File(this.tmpDir + File.separator + className + ".class");
            tempFile = new File(this.tmpDir + File.separator + className + ".java");
            if (!clazzFile.exists() || clazzFile.lastModified() < this.templateFile.lastModified()) {
                PrintStream javaOut = new PrintStream(new FileOutputStream(tempFile));
                new File(this.tmpDir + File.separator + className + ".class").delete();
                FileInputStream in = null;
                in = new FileInputStream(this.templateFile);
                TemplateSplitter splitter = new TemplateSplitter(in, javaOut);
                splitter.setClazzName(className);
                splitter.run();
                splitter.closeIn();
                splitter.closeOut();
                System.out.println("Compiling:" + tempFile.getAbsolutePath());
                JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                DiagnosticCollector diagnostics = new DiagnosticCollector();
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
                File[] files = new File[]{tempFile};
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(files));
                compiler.getTask(null, fileManager, diagnostics, null, null, compilationUnits).call();
                boolean error = false;
                for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                    if (diagnostic.getSource() == null) continue;
                    error = true;
                    System.out.println(diagnostic.getMessage(Locale.getDefault()) + " in line " + diagnostic.getLineNumber() + " in " + diagnostic.getSource());
                }
                fileManager.close();
                if (error) {
                    return false;
                }
            }
            File clzFi = new File(this.tmpDir + File.separator + className + ".class");
            int len = (int)clzFi.length();
            byte[] clz = new byte[len];
            FileInputStream clzIn = new FileInputStream(clzFi);
            clzIn.read(clz);
            clzIn.close();
            myCl.defineClass(clz);
            Class<?> clazz = null;
            try {
                clazz = myCl.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                throw new TemplateExecutionException("ERROR: Could not locate compiled class, please add '.\\tempgen' to your bootclasspath");
            }
            System.out.println("loaded class:" + clazz.getName());
            Object target = clazz.newInstance();
            PrintStream out = output;
            if (out == null) {
                out = new PrintStream(new FileOutputStream(this.outputFile));
            }
            if (this.sysout) {
                ((IContextReceiver)target).receiveContext(this.context, System.out);
            }
            ((IContextReceiver)target).receiveContext(this.context, out);
            if (this.outputFile != null) {
                out.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TemplateExecutionException("Error during template Execution, view System.out");
        }
        return true;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public static void main(String[] arg) {
        TemplateExecutor.Run(arg[0], arg[1]);
    }

    static class MyCL
    extends ClassLoader {
        MyCL() {
        }

        public void defineClass(byte[] b) {
            super.defineClass(b, 0, b.length);
        }
    }
}

