/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.services.rlserver.mongodb;

import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.records.MapRecord;

public class MongoUtil {
    static MongoUtil singleton = new MongoUtil();

    public static MongoUtil get() {
        return singleton;
    }

    public Document fromRecord(Record r) {
        String key = r.getKey();
        Document res = new Document();
        if (key != null) {
            res.put("key", (Object)key);
        }
        res.put("lastModified", (Object)r.getLastModified());
        String[] fields = r.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if ("_id".equals(field)) continue;
            Object value = r.get(field);
            res.put(field, this.fromJavaValue(value));
        }
        return res;
    }

    public Object fromJavaValue(Object value) {
        if (value instanceof Object[]) {
            ArrayList<Object> jarr = new ArrayList<Object>(((Object[])value).length);
            Object[] arr = (Object[])value;
            for (int j = 0; j < arr.length; ++j) {
                jarr.add(this.fromJavaValue(arr[j]));
            }
            return jarr;
        }
        if (value instanceof Record) {
            return this.fromRecord((Record)value);
        }
        if (value == null) {
            return null;
        }
        return value;
    }

    public Record toRecord(Document doc) {
        MapRecord aNew = MapRecord.New(null);
        doc.entrySet().forEach(entry -> {
            String field = (String)entry.getKey();
            if ("key".equals(field)) {
                aNew.key(doc.get((Object)field).toString());
                return;
            }
            if ("_id".equals(field)) {
                aNew.put("_id", (Object)((ObjectId)doc.get((Object)field)).toString());
                return;
            }
            Object jsonValue = doc.get((Object)field);
            if (jsonValue instanceof String) {
                aNew.put(field, jsonValue);
            } else if (jsonValue == null) {
                aNew.put(field, null);
            } else if (jsonValue instanceof Byte) {
                aNew.put(field, (Object)((Byte)jsonValue).longValue());
            } else if (jsonValue instanceof Short) {
                aNew.put(field, (Object)((Short)jsonValue));
            } else if (jsonValue instanceof Integer) {
                aNew.put(field, (Object)((Integer)jsonValue));
            } else if (jsonValue instanceof Long) {
                aNew.put(field, (Object)((Long)jsonValue));
            } else if (jsonValue instanceof Float) {
                aNew.put(field, (Object)Float.valueOf(((Float)jsonValue).floatValue()));
            } else if (jsonValue instanceof Double) {
                aNew.put(field, (Object)((Double)jsonValue));
            } else if (jsonValue instanceof Boolean) {
                aNew.put(field, (Object)((Boolean)jsonValue));
            } else if (jsonValue instanceof Document) {
                aNew.put(field, (Object)this.toRecord((Document)jsonValue));
            } else if (jsonValue instanceof List) {
                aNew.put(field, (Object)this.toRecordArray((List)jsonValue));
            } else {
                throw new RuntimeException("unexpected json type:" + jsonValue.getClass());
            }
        });
        return aNew;
    }

    public Object[] toRecordArray(List arr) {
        Object[] res = new Object[arr.size()];
        int i = 0;
        for (Object jsonValue : arr) {
            if (jsonValue instanceof String || jsonValue instanceof Number || jsonValue instanceof Boolean) {
                res[i] = jsonValue;
            } else if (jsonValue instanceof Document) {
                res[i] = this.toRecord((Document)jsonValue);
            } else if (jsonValue instanceof List) {
                res[i] = this.toRecordArray((List)jsonValue);
            } else {
                throw new RuntimeException("unexpected json type:" + jsonValue.getClass());
            }
            ++i;
        }
        return res;
    }
}

