/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.services.rlserver;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kson.Kson;
import org.nustaq.reallive.api.TableDescription;

public class SimpleRLConfig
implements Serializable {
    public static SimpleRLConfig get;
    protected String dataDir = "./data";
    protected int numNodes = 3;
    protected TableDescription[] tables;
    protected int numSessionThreads = 4;
    protected int bindPort = 8081;
    protected boolean runDataClusterInsideWebserver = true;
    protected String publicUrl = "http://localhost:" + this.bindPort;
    protected String bindIp = "0.0.0.0";
    protected String wsPublicUrl = "ws://localhost:" + this.bindPort + "/ws";
    protected String mongoConnection;
    protected int tcpPort = 7654;
    protected Map<String, Object> customData;
    protected int sessionTimeoutMinutes = 10;
    public static String pathname;

    public static SimpleRLConfig read() {
        return SimpleRLConfig.read(pathname);
    }

    public static SimpleRLConfig read(String pathname) {
        return SimpleRLConfig.read(pathname, SimpleRLConfig.class);
    }

    public static SimpleRLConfig read(String pathname, Class<? extends SimpleRLConfig> simpleRLConfigClass) {
        Kson kson = new Kson().map(new Class[]{simpleRLConfigClass, TableDescription.class});
        try {
            SimpleRLConfig clCfg = (SimpleRLConfig)kson.readObject(new File(pathname));
            String confString = kson.writeObject((Object)clCfg);
            System.out.println("run with config from " + new File(pathname).getCanonicalPath());
            get = clCfg;
            return clCfg;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.Warn(null, (String)(pathname + " not found or parse error. " + e.getClass().getSimpleName() + ":" + e.getMessage()));
            try {
                String sampleconf = kson.writeObject((Object)new SimpleRLConfig());
                System.out.println("Try:\n" + sampleconf);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            System.exit(1);
            return new SimpleRLConfig();
        }
    }

    public boolean isRunDataClusterInsideWebserver() {
        return this.runDataClusterInsideWebserver;
    }

    public String getWsPublicUrl() {
        return this.wsPublicUrl;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public TableDescription[] getTables() {
        return this.tables;
    }

    public int getNumSessionThreads() {
        return this.numSessionThreads;
    }

    public static String getPathname() {
        return pathname;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public String getBindIp() {
        return this.bindIp;
    }

    public int getSessionTimeoutMinutes() {
        return this.sessionTimeoutMinutes;
    }

    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    static {
        pathname = "./etc/reallive.kson";
    }
}

