/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.services.rlserver;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.RemotedActor;
import org.nustaq.kontraktor.services.rlclient.DataClient;
import org.nustaq.kontraktor.services.rlserver.JsonSubsEntry;
import org.nustaq.kontraktor.services.rlserver.RLJsonServer;
import org.nustaq.kontraktor.services.rlserver.SchemaSpore;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.ChangeMessage;
import org.nustaq.reallive.api.ChangeReceiver;
import org.nustaq.reallive.api.RLFunction;
import org.nustaq.reallive.api.RLHashIndexPredicate;
import org.nustaq.reallive.api.RLPredicate;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.Subscriber;
import org.nustaq.reallive.messages.UpdateMessage;
import org.nustaq.reallive.query.QParseException;
import org.nustaq.reallive.server.QueryPredicate;
import org.nustaq.reallive.server.RLUtil;
import org.nustaq.reallive.server.storage.RecordJsonifier;

public class RLJsonSession<T extends RLJsonSession>
extends Actor<T>
implements RemotedActor {
    public static int senderIdRangeStart = 100000;
    public static int senderIdRangeEnd = 5000000;
    protected static AtomicInteger senderIdCount;
    protected RLJsonServer server;
    protected DataClient dClient;
    protected int senderId;
    protected Map<String, JsonSubsEntry> subscriptions = new HashMap<String, JsonSubsEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(RLJsonServer server, DataClient dataClient, Object userdata) {
        Class<RLJsonSession> clazz = RLJsonSession.class;
        synchronized (RLJsonSession.class) {
            if (senderIdCount == null) {
                senderIdCount = new AtomicInteger(senderIdRangeStart);
            }
            this.senderId = senderIdCount.getAndIncrement();
            if (this.senderId >= senderIdRangeEnd) {
                senderIdCount.set(senderIdRangeStart);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.server = server;
            this.dClient = dataClient;
            return;
        }
    }

    public IPromise<Integer> getSenderId() {
        return RLJsonSession.resolve((Object)this.senderId);
    }

    public IPromise update(String table, String json) {
        try {
            this.updateAsync(table, json);
        }
        catch (Exception e) {
            String message = e.getMessage();
            return RLJsonSession.reject((Object)(message == null ? e.toString() : e));
        }
        return RLJsonSession.resolve((Object)true);
    }

    public void updateAsync(String table, String json) {
        JsonValue parse = Json.parse((String)json);
        if (!parse.isObject()) {
            throw new RuntimeException("not a json object:" + json);
        }
        JsonObject members = parse.asObject();
        RealLiveTable tbl = this.dClient.tbl(table);
        if (tbl == null) {
            throw new RuntimeException("table '" + table + "' not found");
        }
        Record record = this.toRecord(members);
        if (record.getKey() == null) {
            throw new RuntimeException("no key in record");
        }
        this._internalUpdate(tbl, record);
    }

    public IPromise delete(String table, String key) {
        try {
            this.deleteAsync(table, key);
        }
        catch (Exception e) {
            String message = e.getMessage();
            return RLJsonSession.reject((Object)(message == null ? e.toString() : e));
        }
        return RLJsonSession.resolve((Object)true);
    }

    public IPromise<Set<String>> fieldsOf(String table) {
        Promise res = new Promise();
        RealLiveTable tbl = this.dClient.tbl(table);
        if (tbl == null) {
            return RLJsonSession.reject((Object)("table '" + table + "' not found"));
        }
        SchemaSpore.apply(tbl).then((Callback & Serializable)(r, e) -> {
            if (r != null) {
                res.resolve((Object)r.toArray(new String[r.size()]));
            } else {
                res.reject(e);
            }
        });
        return res;
    }

    public IPromise<String> get(String table, String key) {
        Promise res = new Promise();
        RealLiveTable tbl = this.dClient.tbl(table);
        if (tbl == null) {
            RLJsonSession.reject((Object)("table '" + table + "' not found"));
        }
        tbl.get(key).then((arg_0, arg_1) -> this.lambda$get$10954f75$1((IPromise)res, arg_0, arg_1));
        return res;
    }

    public void selectHashed(String table, String indexPath2hashKeyJson, String query, Callback<String> res) {
        JsonObject parse;
        RealLiveTable tbl = this.dClient.tbl(table);
        AtomicBoolean hadErr = new AtomicBoolean(false);
        if (tbl == null) {
            res.reject((Object)("table '" + table + "' not found"));
        }
        try {
            parse = Json.parse((String)indexPath2hashKeyJson).asObject();
        }
        catch (Exception e2) {
            Log.Info((Object)((Object)this), (Throwable)e2);
            res.reject((Object)e2);
            return;
        }
        RLHashIndexPredicate predicate = new RLHashIndexPredicate((RLPredicate)new QueryPredicate(query));
        parse.names().forEach(name -> {
            if (name.startsWith("-")) {
                predicate.subtract(name.substring(1), RecordJsonifier.get().toJavaValue(parse.get(name)));
            } else if (name.startsWith("/")) {
                predicate.intersect(name.substring(1), RecordJsonifier.get().toJavaValue(parse.get(name)));
            } else {
                predicate.join(name, RecordJsonifier.get().toJavaValue(parse.get(name)));
            }
        });
        tbl.forEach((RLPredicate)predicate, (Callback & Serializable)(r, e) -> {
            if (r != null) {
                res.pipe((Object)this.fromRecord((Record)r).toString());
            } else if (e != null) {
                if (!hadErr.get()) {
                    if (e instanceof QParseException) {
                        res.reject((Object)("Error in Query:" + ((QParseException)((Object)((Object)e))).getMessage()));
                    } else {
                        res.reject(e);
                    }
                    hadErr.set(true);
                }
            } else {
                res.finish();
            }
        });
    }

    public void select(String table, String query, Callback<String> res) {
        RealLiveTable tbl = this.dClient.tbl(table);
        AtomicBoolean hadErr = new AtomicBoolean(false);
        if (tbl == null) {
            res.reject((Object)("table '" + table + "' not found"));
        }
        tbl.query(query, (Callback & Serializable)(r, e) -> {
            if (r != null) {
                res.pipe((Object)this.fromRecord((Record)r).toString());
            } else if (e != null) {
                if (!hadErr.get()) {
                    if (e instanceof QParseException) {
                        res.reject((Object)("Error in Query:" + ((QParseException)((Object)((Object)e))).getMessage()));
                    } else {
                        res.reject(e);
                    }
                    hadErr.set(true);
                }
            } else {
                res.finish();
            }
        });
    }

    public void unsubscribe(String uuid) {
        JsonSubsEntry subsEntry = this.subscriptions.get(uuid);
        if (subsEntry != null) {
            Callback callback = subsEntry.feCB;
            this.dClient.unsubscribe(subsEntry.subs.getId());
            if (callback != null) {
                callback.finish();
                this.subscriptions.remove(uuid);
            }
        }
    }

    public void subscribe(String uuid, String table, String query, Callback<String> res) {
        RealLiveTable tbl = this.dClient.tbl(table);
        if (tbl == null) {
            res.reject((Object)("table '" + table + "' not found"));
        }
        Subscriber subscriber = tbl.subscribeOn(query, (ChangeReceiver & Serializable)change -> {
            if (change != null) {
                res.pipe((Object)this.fromChange(change).toString());
            } else {
                res.finish();
            }
        });
        this.subscriptions.put(uuid, new JsonSubsEntry(res, subscriber));
    }

    public IPromise<Long> subscribeSyncing(String uuid, String table, long timeStamp, String query, Callback<String> res) {
        RealLiveTable tbl = this.dClient.tbl(table);
        if (tbl == null) {
            res.reject((Object)("table '" + table + "' not found"));
        }
        QueryPredicate filter = new QueryPredicate(query);
        Subscriber subs = new Subscriber((RLPredicate & Serializable)rec -> rec.getLastModified() >= timeStamp && filter.test(rec), (ChangeReceiver & Serializable)change -> {
            if (change != null) {
                res.pipe((Object)this.fromChange(change).toString());
            } else {
                res.finish();
            }
        });
        this.subscriptions.put(uuid, new JsonSubsEntry(res, subs));
        tbl.subscribe(subs);
        return RLJsonSession.resolve((Object)System.currentTimeMillis());
    }

    protected JsonObject fromChange(ChangeMessage change) {
        switch (change.getType()) {
            case 0: {
                JsonObject result = Json.object();
                result.set("type", "ADD");
                result.set("senderId", change.getSenderId());
                result.set("record", (JsonValue)this.fromRecord(change.getRecord()));
                return result;
            }
            case 1: {
                JsonObject result = Json.object();
                result.set("type", "REMOVE");
                result.set("senderId", change.getSenderId());
                result.set("record", (JsonValue)this.fromRecord(change.getRecord()));
                return result;
            }
            case 2: {
                JsonObject result = Json.object();
                result.set("type", "UPDATE");
                result.set("senderId", change.getSenderId());
                result.set("record", (JsonValue)this.fromRecord(change.getRecord()));
                JsonObject diff = new JsonObject();
                UpdateMessage upd = (UpdateMessage)change;
                String[] changedFields = upd.getDiff().getChangedFields();
                Object[] oldValues = upd.getDiff().getOldValues();
                for (int i = 0; i < changedFields.length; ++i) {
                    String changedField = changedFields[i];
                    diff.set(changedField, RecordJsonifier.get().fromJavaValue(oldValues[i]));
                }
                result.set("diff", (JsonValue)diff);
                return result;
            }
            case 3: {
                JsonObject result = Json.object();
                result.set("type", "QUERYDONE");
                return result;
            }
        }
        Log.Error((Object)((Object)this), (String)"unexpected change type");
        return null;
    }

    public void deleteAsync(String table, String key) {
        RealLiveTable tbl = this.dClient.tbl(table);
        if (tbl == null) {
            throw new RuntimeException("table '" + table + "' not found");
        }
        tbl.remove(this.senderId, key);
    }

    public IPromise<Long> bulkUpdate(String table, String json) {
        try {
            JsonObject parse = Json.parse((String)json).asObject();
            RealLiveTable tbl = this.dClient.tbl(table);
            parse.forEach(member -> member.getValue().asArray().forEach(addupd -> {
                try {
                    JsonObject obj = addupd.asObject();
                    Record newRecord = this.toRecord(obj);
                    newRecord.key(member.getName());
                    this._internalUpdate(tbl, newRecord);
                }
                catch (Exception e) {
                    Log.Error((Object)((Object)this), (Throwable)e);
                }
            }));
        }
        catch (Exception e) {
            return RLJsonSession.reject((Object)e);
        }
        return RLJsonSession.resolve((Object)System.currentTimeMillis());
    }

    protected void _internalUpdate(RealLiveTable tbl, Record newRecord) {
        int finalSID = this.senderId;
        tbl.atomic(finalSID, newRecord.getKey(), (RLFunction & Serializable)currentRecord -> {
            if (currentRecord != null) {
                String[] fields = newRecord.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    String field = fields[i];
                    if (field.endsWith("+")) {
                        boolean set = field.endsWith("?+");
                        Object toAdd = newRecord.get(field);
                        String pureField = field.substring(0, field.length() - (set ? 2 : 1));
                        Object o = currentRecord.get(pureField);
                        if (o instanceof Object[]) {
                            Object[] oldarr = (Object[])o;
                            boolean matched = false;
                            if (set) {
                                for (int j = 0; j < oldarr.length; ++j) {
                                    Object o1 = oldarr[j];
                                    if (!Objects.deepEquals(o1, toAdd)) continue;
                                    matched = true;
                                    break;
                                }
                            }
                            if (matched) continue;
                            Object[] newCopy = new Object[oldarr.length + 1];
                            System.arraycopy(oldarr, 0, newCopy, 0, oldarr.length);
                            newCopy[oldarr.length] = toAdd;
                            currentRecord.put(pureField, (Object)newCopy);
                            continue;
                        }
                        currentRecord.put(pureField, (Object)new Object[]{toAdd});
                        continue;
                    }
                    if (field.endsWith("-")) {
                        String purefield = field.substring(0, field.length() - 1);
                        Object toRem = newRecord.get(field);
                        if ("_NULL_".equals(toRem)) {
                            toRem = null;
                        }
                        Object o = currentRecord.get(purefield);
                        Object[] oldarr = (Object[])o;
                        Object finalToRem = toRem;
                        Object[] collect = Arrays.asList(oldarr).stream().filter(x -> !Objects.deepEquals(x, finalToRem)).collect(Collectors.toList()).toArray();
                        currentRecord.put(purefield, (Object)collect);
                        continue;
                    }
                    currentRecord.put(field, newRecord.get(field));
                }
                return null;
            }
            Object[] keyVals = newRecord.getKeyVals();
            for (int i = 0; i < keyVals.length; i += 2) {
                String keyVal = (String)keyVals[i];
                if (keyVal.endsWith("?+")) {
                    keyVals[i] = keyVal.substring(0, keyVal.length() - 2);
                    continue;
                }
                if (keyVal.endsWith("-")) {
                    keyVals[i] = keyVal.substring(0, keyVal.length() - 1);
                    continue;
                }
                if (!keyVal.endsWith("+")) continue;
                keyVals[i] = keyVal.substring(0, keyVal.length() - 1);
            }
            return RLUtil.get().addOrUpdate(finalSID, newRecord.getKey(), keyVals);
        });
    }

    protected JsonObject fromRecord(Record r) {
        return RecordJsonifier.get().fromRecord(r);
    }

    protected Record toRecord(JsonObject members) {
        return RecordJsonifier.get().toRecord(members);
    }

    public void hasBeenUnpublished(String connectionIdentifier) {
        HashMap<String, JsonSubsEntry> copy = new HashMap<String, JsonSubsEntry>(this.subscriptions.size());
        copy.putAll(this.subscriptions);
        copy.forEach((k, en) -> this.unsubscribe((String)k));
    }

    public void hasBeenPublished(String connectionIdentifier) {
    }

    private /* synthetic */ void lambda$get$10954f75$1(IPromise res, Record r, Object e) {
        if (r != null) {
            res.resolve((Object)this.fromRecord(r).toString());
        } else {
            res.reject(e);
        }
    }
}

