/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.services.rlserver;

import java.io.File;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Scheduler;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.apputil.LoginData;
import org.nustaq.kontraktor.apputil.SessionEvent;
import org.nustaq.kontraktor.impl.BackOffStrategy;
import org.nustaq.kontraktor.impl.SimpleScheduler;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.http.undertow.Http4K;
import org.nustaq.kontraktor.remoting.tcp.TCPPublisher;
import org.nustaq.kontraktor.services.rlclient.DataClient;
import org.nustaq.kontraktor.services.rlserver.RLJsonAuthResult;
import org.nustaq.kontraktor.services.rlserver.RLJsonServerService;
import org.nustaq.kontraktor.services.rlserver.RLJsonSession;
import org.nustaq.kontraktor.services.rlserver.SimpleRLConfig;
import org.nustaq.kontraktor.services.rlserver.SingleProcessRLCluster;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.messages.AddMessage;
import org.nustaq.reallive.messages.Diff;
import org.nustaq.reallive.messages.QueryDoneMessage;
import org.nustaq.reallive.messages.RemoveMessage;
import org.nustaq.reallive.messages.UpdateMessage;
import org.nustaq.reallive.records.MapRecord;

public class RLJsonServer<T extends RLJsonServer>
extends Actor<T> {
    public static final Class[] CLAZZES = new Class[]{LoginData.class, MapRecord.class, AddMessage.class, UpdateMessage.class, RemoveMessage.class, QueryDoneMessage.class, SessionEvent.class, RLJsonAuthResult.class, Diff.class};
    private static SimpleRLConfig cfg;
    protected Scheduler[] clientThreads;
    protected Random rand = new Random();
    protected RLJsonServerService service;
    protected DataClient dclient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleRLConfig Cfg() {
        Class<RLJsonServer> clazz = RLJsonServer.class;
        synchronized (RLJsonServer.class) {
            if (cfg == null) {
                cfg = SimpleRLConfig.read();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cfg;
        }
    }

    @Local
    public IPromise init(String[] args) {
        this.clientThreads = new Scheduler[RLJsonServer.Cfg().getNumSessionThreads()];
        IntStream.range(0, RLJsonServer.Cfg().getNumSessionThreads()).forEach(i -> {
            this.clientThreads[i] = new SimpleScheduler(10000, true);
        });
        this.service = RLJsonServerService.start(args);
        this.service.setWebServer((RLJsonServer)this.self());
        this.dclient = this.service.getDClient();
        return RLJsonServer.resolve();
    }

    public IPromise<RLJsonAuthResult> authenticate(String user, String pwd) {
        Log.Info((Object)((Object)this), (String)"authenticate session");
        return this.createSession(new Object[]{user, pwd});
    }

    protected IPromise<RLJsonAuthResult> createSession(Object customSessionData) {
        RLJsonSession session = (RLJsonSession)RLJsonServer.AsActor(this.getSessionActorClazz(customSessionData), (Scheduler)this.clientThreads[this.rand.nextInt(this.clientThreads.length)]);
        session.init((RLJsonServer)this.self(), this.dclient, customSessionData);
        return RLJsonServer.resolve((Object)new RLJsonAuthResult().session(session));
    }

    protected Class<? extends RLJsonSession> getSessionActorClazz(Object authData) {
        return RLJsonSession.class;
    }

    @CallerSideMethod
    protected void createServer(RLJsonServer app, Class[] CLAZZES) {
        Http4K.Build((String)RLJsonServer.Cfg().getBindIp(), (int)RLJsonServer.Cfg().getBindPort()).httpAPI("/api", (Actor)app).coding(new Coding(SerializerType.JsonNoRef, CLAZZES)).setSessionTimeout(TimeUnit.MINUTES.toMillis(cfg.getSessionTimeoutMinutes())).buildHttpApi().websocket("/ws", (Actor)app).coding(new Coding(SerializerType.JsonNoRef, CLAZZES)).buildWebsocket().build();
        new TCPPublisher((Actor)app, RLJsonServer.Cfg().tcpPort).publish(dis -> System.out.println("disconnected"));
    }

    @CallerSideMethod
    @Local
    public DataClient getDClient() {
        return ((RLJsonServer)this.getActor()).dclient;
    }

    public static void main(String[] args) throws InterruptedException {
        BackOffStrategy.SLEEP_NANOS = 5000000;
        Class<RLJsonServer> appClazz = RLJsonServer.class;
        RLJsonServer.startUp(args, appClazz);
    }

    public static void startUp(String[] args, Class appClazz) throws InterruptedException {
        if (!new File(SimpleRLConfig.pathname).exists()) {
            System.out.println("Please run with project working dir");
            System.exit(-1);
        }
        if (RLJsonServer.Cfg().runDataClusterInsideWebserver) {
            SingleProcessRLCluster.main(new String[0]);
        }
        RLJsonServer app = (RLJsonServer)RLJsonServer.AsActor((Class)appClazz);
        app.init(args).await(300000L);
        Log.Info((Object)appClazz, (String)("listening on http://" + RLJsonServer.Cfg().getBindIp() + ":" + RLJsonServer.Cfg().getBindPort()));
        app.createServer(app, CLAZZES);
    }
}

