/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.services.rlclient.dynamic;

import java.util.HashMap;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.services.ServiceActor;
import org.nustaq.kontraktor.services.datacluster.DataCfg;
import org.nustaq.kontraktor.services.datacluster.dynamic.DynDataServiceRegistry;
import org.nustaq.kontraktor.services.rlclient.DataClient;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.TableDescription;
import org.nustaq.reallive.client.DynTableSpaceSharding;
import org.nustaq.reallive.client.TableSpaceSharding;
import org.nustaq.reallive.server.actors.TableSpaceActor;
import org.nustaq.reallive.server.dynamic.DynClusterDistribution;

public class DynDataClient
extends DataClient<DynDataClient> {
    DynClusterDistribution currentMapping;

    @Override
    public IPromise connect(DataCfg config, TableSpaceActor[] shards, ServiceActor hostingService) {
        this.config = config;
        this.hostingService = hostingService;
        this.shards = shards;
        this.syncTableAccess = new HashMap();
        this.tableSpaceSharding = this.createTableSpaceSharding(shards);
        this.tableSpaceSharding.init().await();
        if (!this.isDynDataCluster()) {
            Log.Error((Object)((Object)this), (String)"FATAL: not running with dynamic registry");
            this.delayed(1000L, () -> System.exit(1));
        }
        hostingService.addServiceEventListener((event, arg) -> this.handleServiceEvent((String)event, arg));
        TableDescription[] schema = config.getSchema();
        return DynDataClient.all((int)schema.length, i -> {
            TableDescription desc = schema[i];
            return this.initTable(desc);
        });
    }

    public void setInitialMapping(DynClusterDistribution mapping) {
        this.currentMapping = mapping;
    }

    protected boolean isDynDataCluster() {
        return this.hostingService.getServiceRegistry() instanceof DynDataServiceRegistry;
    }

    protected void handleServiceEvent(String event, Object arg) {
        if (event.equals("distribution")) {
            this.currentMapping = (DynClusterDistribution)arg;
        }
    }

    @Override
    protected TableSpaceSharding createTableSpaceSharding(TableSpaceActor[] shards) {
        return new DynTableSpaceSharding(shards, () -> this.currentMapping);
    }
}

