/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.services.datacluster;

import com.beust.jcommander.Parameter;
import java.util.function.Supplier;
import org.nustaq.kontraktor.services.ServiceArgs;

public class DataShardArgs
extends ServiceArgs {
    public static Supplier<DataShardArgs> factory = () -> new DataShardArgs();
    @Parameter(required=true, names={"-sn", "-shardNo"})
    int shardNo;
    @Parameter(names={"-dsPortOverride"}, help=true, description="override default exposure port (computed by portBase + shard_no)")
    private int dsPortOverride = 0;

    public static DataShardArgs New() {
        return factory.get();
    }

    public static DataShardArgs from(ServiceArgs toCopy, int shardNo) {
        DataShardArgs aNew = DataShardArgs.New();
        aNew.registryHost(toCopy.getRegistryHost());
        aNew.registry(toCopy.getRegistryPort());
        aNew.help(toCopy.isHelp());
        aNew.host(toCopy.getHost());
        aNew.dataShardPortBase(toCopy.getDataShardPortBase());
        aNew.asyncLog(toCopy.isAsyncLog());
        aNew.monhost(toCopy.getMonhost());
        aNew.monport(toCopy.getMonport());
        aNew.shardNo = shardNo;
        return aNew;
    }

    protected DataShardArgs() {
    }

    public int getShardNo() {
        return this.shardNo;
    }

    public int getDsPortOverride() {
        return this.dsPortOverride;
    }

    @Override
    public String toString() {
        return "DataShardArgs{shardNo=" + this.shardNo + "} " + super.toString();
    }
}

