/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil.comments;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.apputil.UniqueSessionIntIdMixin;
import org.nustaq.kontraktor.apputil.UserRecord;
import org.nustaq.kontraktor.apputil.comments.CommentHistoryRecord;
import org.nustaq.kontraktor.apputil.comments.CommentRecord;
import org.nustaq.kontraktor.services.rlclient.DataClient;
import org.nustaq.kontraktor.util.Pair;
import org.nustaq.reallive.api.ChangeMessage;
import org.nustaq.reallive.api.ChangeReceiver;
import org.nustaq.reallive.api.RLFunction;
import org.nustaq.reallive.api.RLNoQueryPredicate;
import org.nustaq.reallive.api.RLPredicate;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.Subscriber;
import org.nustaq.serialization.FSTConfiguration;

public interface CommentsSessionMixin
extends UniqueSessionIntIdMixin {
    public static final String CommentTableName = "comment";
    public static final String HistoryTableName = "commentHistory";
    public static final String DefaultUserImagePath = "./imgupload/default-user.png";
    public static final FSTConfiguration jsonConfiguration = FSTConfiguration.createJsonConfiguration((boolean)true, (boolean)false);

    @CallerSideMethod
    @Local
    public DataClient getDClient();

    @CallerSideMethod
    @Local
    public UserRecord getUser();

    default public IPromise<Record> createDiscussion() {
        return this.getOrCreateDiscussion(UUID.randomUUID().toString());
    }

    default public IPromise<Record> getOrCreateDiscussion(String commentTreeKey) {
        Promise res = new Promise();
        this.getDClient().tbl(CommentTableName).get(commentTreeKey).then((Callback & Serializable)(r, e) -> {
            if (r != null) {
                res.resolve(r);
            } else {
                long now = System.currentTimeMillis();
                CommentRecord rec = (CommentRecord)((CommentRecord)((CommentRecord)((CommentRecord)((CommentRecord)((CommentRecord)new CommentRecord(commentTreeKey).author(this.getUser().getName())).creation(now)).lastModified(now)).imageURL(this.getUser().getImageURL())).text("root")).id("root");
                this.getDClient().tbl(CommentTableName).setRecord(rec.getRecord());
                res.resolve((Object)rec.getRecord());
            }
        });
        return res;
    }

    public static String dbg_asJson(Record r) {
        return jsonConfiguration.asJsonString((Object)r);
    }

    default public IPromise<CommentRecord> getParentComment(String commentTreeKey, String subCommentId) {
        if (commentTreeKey == null) {
            return Actors.resolve(null);
        }
        RealLiveTable comments = this.getDClient().tbl(CommentTableName);
        return comments.atomic(commentTreeKey, (RLFunction & Serializable)res -> {
            if (res != null) {
                CommentRecord comment = new CommentRecord((Record)res);
                return comment.findParent(subCommentId);
            }
            return null;
        });
    }

    default public IPromise delComment(String rootCommentKey, String commentId) {
        Promise p = new Promise();
        RealLiveTable comments = this.getDClient().tbl(CommentTableName);
        String editorKey = this.getUser().getKey();
        comments.atomic(rootCommentKey, (RLFunction & Serializable)ctree -> {
            if (ctree != null) {
                CommentRecord childNode;
                CommentRecord root = new CommentRecord((Record)ctree);
                if (root.getId() == null) {
                    root.id("root");
                }
                if ((childNode = root.findChildNode(commentId)) != null) {
                    CommentRecord parent = root.findParent(commentId);
                    if (childNode.getChildren().size() > 0) {
                        childNode.text("[deleted]");
                        root.children(root.getChildren());
                        CommentHistoryRecord ch = (CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)new CommentHistoryRecord(UUID.randomUUID().toString()).foreignKey(rootCommentKey)).id(commentId)).parentId(parent.getId())).creation(System.currentTimeMillis())).affectedParentUser(parent.getAuthor()).editorId(editorKey).id(commentId)).text(childNode.getText())).type("edit");
                        return new Pair((Object)childNode.getRecord(), (Object)ch);
                    }
                    parent.delChildNode(commentId);
                    root.children(root.getChildren());
                    CommentHistoryRecord ch = (CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)new CommentHistoryRecord(UUID.randomUUID().toString()).foreignKey(rootCommentKey)).id(commentId)).creation(System.currentTimeMillis())).affectedParentUser(parent.getAuthor()).parentId(parent.getId())).id(commentId)).editorId(editorKey).text(childNode.getText())).type("del");
                    return new Pair(null, (Object)ch);
                }
            }
            return null;
        }).then((Callback & Serializable)(pair, e) -> {
            if (pair != null) {
                CommentHistoryRecord casted = (CommentHistoryRecord)((Pair)pair).getSecond();
                this.getDClient().tbl(HistoryTableName).addRecord(this.getIntSessionId(), (Record)casted);
                p.resolve(casted.getType().equalsIgnoreCase("del") ? "deleted" : ((Pair)pair).getFirst());
            } else {
                p.reject((Object)"comment not found");
            }
        });
        return p;
    }

    default public IPromise<Record> editComment(String commentTreeKey, String commentId, String text0) {
        Promise res = new Promise();
        HashSet mentions = new HashSet();
        String editorKey = this.getUser().getKey();
        RealLiveTable comments = this.getDClient().tbl(CommentTableName);
        this.highLighComment(text0, 0, mentions).then(text -> comments.atomic(commentTreeKey, (RLFunction & Serializable)ctree -> {
            if (ctree != null) {
                CommentRecord childNode;
                CommentRecord root = new CommentRecord((Record)ctree);
                if (root.getId() == null) {
                    root.id("root");
                }
                if ((childNode = root.findChildNode(commentId)) != null) {
                    long now = System.currentTimeMillis();
                    childNode.text((String)text);
                    childNode.lastModified(now);
                    root.lastModified(now);
                    root.children(root.getChildren());
                    CommentRecord parent = root.findParent(commentId);
                    CommentHistoryRecord ch = (CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)new CommentHistoryRecord(UUID.randomUUID().toString()).foreignKey(commentTreeKey)).id(commentId)).creation(now)).editorId(editorKey).parentId(parent.getId())).affectedParentUser(parent != null ? parent.getAuthor() : null).text(childNode.getText())).parentId(parent.getId())).id(commentId)).type("edit");
                    return new Pair((Object)childNode.getRecord(), (Object)ch);
                }
            }
            return null;
        }).then(pair -> {
            if (pair != null) {
                CommentHistoryRecord casted = (CommentHistoryRecord)((Pair)pair).getSecond();
                casted.mentions(mentions);
                this.getDClient().tbl(HistoryTableName).addRecord(this.getIntSessionId(), (Record)casted);
                res.resolve(((Pair)pair).getFirst());
            } else {
                res.reject((Object)"error: no comment record could be found");
            }
        }));
        return res;
    }

    default public IPromise<Record> addComment(String commentTreeKey, String parentCommentId, String text0) {
        Promise res = new Promise();
        HashSet mentions = new HashSet();
        RealLiveTable comments = this.getDClient().tbl(CommentTableName);
        String ukey = this.getUser().getKey();
        String uImg = this.getUser().getImageURL();
        this.highLighComment(text0, 0, mentions).then(text -> {
            String newCommentId = UUID.randomUUID().toString();
            CommentRecord newComment = (CommentRecord)((CommentRecord)((CommentRecord)((CommentRecord)((CommentRecord)((CommentRecord)((CommentRecord)new CommentRecord("").id(newCommentId)).creation(System.currentTimeMillis())).lastModified(System.currentTimeMillis())).text((String)text)).author(this.getUser().getName())).role(this.getUser().getRole())).imageURL(uImg);
            if (newComment.getImageURL() == null || newComment.getImageURL().length() == 0) {
                newComment.imageURL(DefaultUserImagePath);
            }
            comments.atomic(commentTreeKey, (RLFunction & Serializable)ctree -> {
                if (ctree != null) {
                    CommentRecord parentNode;
                    CommentRecord root = new CommentRecord((Record)ctree);
                    if (root.getId() == null) {
                        root.id("root");
                    }
                    if ((parentNode = root.findChildNode(parentCommentId)) != null) {
                        parentNode.addChild(newComment);
                        root.children(root.getChildren());
                        CommentHistoryRecord ch = (CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)((CommentHistoryRecord)new CommentHistoryRecord(newCommentId).foreignKey(commentTreeKey)).id(parentCommentId)).creation(System.currentTimeMillis())).id(newComment.getId())).text((String)text)).author(newComment.getAuthor())).imageURL(newComment.getImageURL())).parentId(parentCommentId)).editorId(ukey).affectedParentUser(parentNode.getAuthor()).type("add");
                        return ch;
                    }
                }
                return null;
            }).then(ch -> {
                if (ch != null) {
                    CommentHistoryRecord casted = (CommentHistoryRecord)ch;
                    casted.mentions(mentions);
                    this.getDClient().tbl(HistoryTableName).addRecord(this.getIntSessionId(), (Record)casted);
                }
            });
            res.resolve((Object)newComment.getRecord());
        });
        return res;
    }

    default public IPromise<String> highLighComment(String comment, int index, Set mentions) {
        Promise res = new Promise();
        if (comment != null || index >= comment.length()) {
            char c;
            int idx = comment.indexOf("@", index);
            if (idx > 0 && (c = comment.charAt(idx - 1)) != ' ' && c != '\u00a0' && c != '>' && c != ';') {
                return this.highLighComment(comment, idx + 1, mentions);
            }
            RealLiveTable userTable = this.getDClient().tbl("user");
            while (idx >= 0) {
                int idx1;
                if (idx < 0) continue;
                boolean quoted = false;
                if (idx1 < comment.length() && comment.charAt(idx1) == '\'') {
                    ++idx1;
                    ++idx;
                    while (idx1 < comment.length() && comment.charAt(idx1) != '\'') {
                        ++idx1;
                    }
                    quoted = true;
                } else {
                    for (idx1 = idx + 1; idx1 < comment.length() && Character.isLetterOrDigit(comment.charAt(idx1)); ++idx1) {
                    }
                }
                if (idx1 <= idx) continue;
                String name = comment.substring(idx + 1, idx1);
                int finalIdx = idx1 + (quoted ? 1 : 0);
                int finalIdx1 = idx;
                userTable.find((RLPredicate & Serializable)rec -> rec.getSafeString("name").equalsIgnoreCase(name)).then((Callback & Serializable)(rec, err) -> {
                    if (rec != null) {
                        UserRecord ulight = UserRecord.lightVersion(rec);
                        String unam = ulight.getName();
                        String replace = "<a href='/#/profiles/" + unam + "'>" + unam + "</a>";
                        String formatted = comment.substring(0, finalIdx1) + replace + comment.substring(finalIdx);
                        mentions.add(rec.getKey());
                        this.highLighComment(formatted, finalIdx1 + replace.length(), mentions).then((Callback)res);
                    }
                });
                return res;
            }
        }
        return Actors.resolve((Object)comment);
    }

    @Local
    @CallerSideMethod
    default public Subscriber listenCommentHistory(Callback<ChangeMessage> rec) {
        return this.getDClient().tbl(HistoryTableName).listen((RLNoQueryPredicate & Serializable)r -> true, (ChangeReceiver & Serializable)chrec -> rec.pipe((Object)chrec));
    }
}

