/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.apputil.SessionEvent;
import org.nustaq.kontraktor.apputil.UserRecord;
import org.nustaq.kontraktor.services.rlclient.DataClient;
import org.nustaq.reallive.api.ChangeReceiver;
import org.nustaq.reallive.api.Subscriber;
import org.nustaq.serialization.coders.Unknown;

public interface SessionHandlingSessionMixin {
    @CallerSideMethod
    @Local
    public DataClient getDClient();

    @CallerSideMethod
    @Local
    public UserRecord getUser();

    @CallerSideMethod
    @Local
    public List<Subscriber> getSubscriptions();

    default public IPromise saveProfile(Unknown data) {
        Promise p = new Promise();
        String pwd = data.getString("pwd");
        String verifyPwd = data.getString("verifyPwd");
        String oldPwd = data.getString("oldPwd");
        data.getFields().forEach((k, v) -> {
            if (!("pwd".equals(k) || "verifyPwd".equals(k) || "oldPwd".equals(k) || "name".equals(k))) {
                this.getUser().put((String)k, v);
            }
        });
        if (pwd != null && pwd.length() > 0) {
            if (!this.getUser().getPwd().equals(oldPwd)) {
                p.reject((Object)"altes Passwort ist falsch, das Passwort wurde nicht ge\u00e4ndert");
            } else if (verifyPwd == null || !verifyPwd.equals(pwd)) {
                p.reject((Object)"neues Passwort wurde falsch wiederholt");
            } else if (pwd.length() < 6 || pwd.length() > 20) {
                p.reject((Object)"neues Passwort muss zwischen 6 und 20 Zeichen lang sein");
            } else {
                this.getUser().pwd(pwd);
                this.getDClient().tbl("user").setRecord(this.getUser().getRecord());
                p.resolve((Object)"Daten und Passwort ge\u00e4ndert");
            }
        } else {
            this.getDClient().tbl("user").setRecord(this.getUser().getRecord());
            p.resolve((Object)"Daten ge\u00e4ndert");
        }
        return p;
    }

    default public void subscribeUserRecord(UserRecord user, Callback uiSubscription, AtomicBoolean initialDataDone) {
        this.getSubscriptions().add(this.getDClient().tbl("user").subscribeOn("_key == '" + user.getEmail() + "'", (ChangeReceiver & Serializable)change -> {
            if (change.isDoneMsg()) {
                initialDataDone.set(true);
            } else if (initialDataDone.get()) {
                uiSubscription.pipe((Object)new SessionEvent("user", change));
            }
        }));
    }
}

