/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.apputil.MailCfg;
import org.nustaq.kontraktor.apputil.MailChannel;
import org.nustaq.kontraktor.util.Log;

public class Mailer
extends Actor<Mailer> {
    public static boolean DEBUG_MAIL = false;
    static Mailer singleton;
    MailCfg settings;
    String publicUrl;

    public static void initSingleton(MailCfg settings, String publicUrl) {
        Mailer m = (Mailer)Mailer.AsActor(Mailer.class);
        m.init(settings, publicUrl);
        singleton = m;
    }

    public static Mailer get() {
        return singleton;
    }

    public void init(MailCfg conf, String publicUrl) {
        this.publicUrl = publicUrl;
        this.updateSettings(conf);
    }

    public void updateSettings(MailCfg conf) {
        this.settings = conf;
    }

    public static String applyTemplate(String templateFileRelativeToTemplateDir, Map<String, Object> data, BiFunction<String, Object, String> mapFun) throws IOException {
        String t = new String(Files.readAllBytes(Paths.get(((Mailer)Mailer.get().getActor()).settings.getTemplateBase() + templateFileRelativeToTemplateDir, new String[0])), "UTF-8");
        for (Map.Entry<String, Object> e : data.entrySet()) {
            t = t.replace("$" + e.getKey() + "$", mapFun.apply(e.getKey(), e.getValue()));
        }
        return t;
    }

    public IPromise<Boolean> sendEMail(String receiver, String subject, String content, String senderEmail, String displayName) {
        if (receiver == null || !receiver.contains("@")) {
            return new Promise((Object)false, (Object)("Not a valid email address: " + receiver));
        }
        if (DEBUG_MAIL) {
            System.out.println("EMAIL to:" + receiver + " " + subject + " from:" + senderEmail + " " + displayName);
            System.out.println(content);
            return new Promise((Object)true);
        }
        try {
            Properties props = new Properties();
            props.put("mail.smtp.auth", this.settings.getSmtpAuth());
            props.put("mail.smtp.starttls.enable", this.settings.getStartTls());
            props.put("mail.smtp.host", this.settings.getSmtpHost());
            props.put("mail.smtp.port", this.settings.getSmtpPort());
            Session session = Session.getInstance((Properties)props);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)(displayName == null ? new InternetAddress(senderEmail) : new InternetAddress(senderEmail, displayName)));
            message.setSubject(subject);
            message.setText(content, "utf-8", "html");
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(receiver, false));
            message.setSentDate(new Date());
            Transport.send((Message)message, (String)this.settings.getUser(), (String)this.settings.getPassword());
            Log.Info((Object)((Object)this), (String)("definitely sent mail to " + receiver + " subject:" + subject));
            return new Promise((Object)true);
        }
        catch (Exception e) {
            Log.Warn((Object)((Object)this), (Throwable)e);
            return new Promise((Object)false, (Object)e);
        }
    }

    public IPromise<Boolean> sendDefaultMail(String receiver, String subject, String content) {
        return this.sendChannelMail("default", receiver, subject, content);
    }

    public IPromise<Boolean> sendChannelMail(String channel, String receiver, String subject, String content) {
        MailChannel channelSettings = this.settings.getChannel(channel);
        return this.sendEMail(receiver, subject, content, channelSettings.getEmail(), channelSettings.getDisplayName());
    }

    public IPromise<Boolean> sendTemplateChannelMail(String channel, String receiver, String subject, String templateFile, Map<String, Object> data) {
        MailChannel channelSettings = this.settings.getChannel(channel);
        data.put("public-url", this.publicUrl);
        try {
            String content = Mailer.applyTemplate(templateFile, data, (k, v) -> "" + v);
            return this.sendEMail(receiver, subject, content, channelSettings.getEmail(), channelSettings.getDisplayName());
        }
        catch (IOException e) {
            Log.Error((Object)((Object)this), (Throwable)e);
            return Mailer.reject((Object)e);
        }
    }
}

