/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil;

import io.undertow.server.HttpServerExchange;
import java.io.Serializable;
import java.util.UUID;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.remoting.http.undertow.builder.BldFourK;
import org.nustaq.kontraktor.services.rlclient.DataClient;
import org.nustaq.reallive.api.Record;

public interface LinkMapperMixin<SELF extends Actor<SELF>> {
    public static final String LinkTableName = "links";

    public static void auto(BldFourK bld, Object linkMapper) {
        bld.httpHandler(LinkTableName, httpServerExchange -> {
            httpServerExchange.dispatch();
            ((LinkMapperMixin)linkMapper).handleLinkHttp(httpServerExchange);
        });
    }

    @CallerSideMethod
    @Local
    public DataClient getDClient();

    @CallerSideMethod
    @Local
    public String handleLinkSuccess(String var1, Record var2);

    @CallerSideMethod
    @Local
    public String handleLinkFailure(String var1);

    public SELF getActor();

    default public IPromise<String> putRecord(Record rec) {
        String key = UUID.randomUUID().toString();
        rec.key(key);
        this.getDClient().tbl(LinkTableName).setRecord(rec.key(key));
        return Actors.resolve((Object)key);
    }

    default public void handleLinkHttp(HttpServerExchange httpServerExchange) {
        String path = httpServerExchange.getRelativePath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String finalPath = path;
        this.getDClient().tbl(LinkTableName).get(path).then((Callback & Serializable)(rec, err) -> {
            if (rec != null) {
                httpServerExchange.setResponseCode(200).getResponseSender().send(((LinkMapperMixin)this.getActor()).handleLinkSuccess(finalPath, (Record)rec));
            } else {
                httpServerExchange.setResponseCode(200).getResponseSender().send(((LinkMapperMixin)this.getActor()).handleLinkFailure(finalPath));
            }
        });
    }
}

