/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.imgscalr.Scalr;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.util.Log;

public class ImageSaver {
    static float DEFAULT_IMAGE_COMPRESSION_VALUE = 0.5f;
    String basePath;

    public ImageSaver(String basePath) {
        this.basePath = basePath;
    }

    public IPromise<String> handleImage(String base64Image, String imgType, String path, Dimension targetSize) {
        Promise prom = new Promise();
        Base64.Decoder decoder = Base64.getDecoder();
        int i = base64Image.indexOf(";base64");
        if (i < 0) {
            prom.reject((Object)"Not a Base64 Image");
            return prom;
        }
        String str = base64Image.substring(i + ";base64".length() + 1);
        try {
            byte[] decodedBytes = decoder.decode(str);
            BufferedImage img = this.scalePreservingAspectRatioAsImage(decodedBytes, targetSize.width, targetSize.height);
            if (img == null) {
                prom.complete((Object)"Error scaling image...", null);
                return prom;
            }
            String fileEnding = this.validateType(imgType);
            String fileName = UUID.randomUUID().toString() + "." + fileEnding;
            String fullPath = this.basePath + "/" + fileName;
            boolean success = this.saveImage(img, fullPath);
            if (success) {
                String imageId = fileName;
                prom.complete((Object)imageId, null);
                return prom;
            }
            prom.complete(null, (Object)"Image scaling incomplete ..");
            return prom;
        }
        catch (Exception exc) {
            Log.Error((Object)this, (Throwable)exc);
            prom.reject((Object)exc.getMessage());
            return prom;
        }
    }

    protected String imageEndingByMimeType(String mimeType) {
        switch (mimeType) {
            case "image/cis-cod": {
                return "cod";
            }
            case "image/cmu-raster": {
                return "ras";
            }
            case "image/fif": {
                return "fif";
            }
            case "image/gif": {
                return "gif";
            }
            case "image/ief": {
                return "ief";
            }
            case "image/png": {
                return "png";
            }
            case "image/tiff": {
                return "tif";
            }
            case "image/vasa": {
                return "mcf";
            }
            case "image/vnd.wap.wbmp": {
                return "wbmp";
            }
            case "image/jpeg": 
            case "image/jpg": {
                return "jpg";
            }
            case "image/x-freehand": {
                return "fhc";
            }
            case "image/x-icon": {
                return "ico";
            }
            case "image/x-portable-anymap": {
                return "pnm";
            }
            case "image/x-portable-bitmap": {
                return "pbm";
            }
            case "image/x-portable-graymap": {
                return "pgm";
            }
            case "image/x-portable-pixmap": {
                return "ppm";
            }
            case "image/x-rgb": {
                return "rgb";
            }
            case "image/x-windowdump": {
                return "xwd";
            }
            case "image/x-xbitmap": {
                return "xbm";
            }
            case "image/x-xpixmap": {
                return "xpm";
            }
        }
        return "jpg";
    }

    protected String validateType(String type) {
        if (type == null) {
            return "jpg";
        }
        if ((type = type.toLowerCase()).indexOf("/") >= 0) {
            return this.imageEndingByMimeType(type);
        }
        return "jpg";
    }

    protected boolean saveImage(BufferedImage img, String fileName) {
        try {
            String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
            File sized = new File(fileName);
            sized.mkdirs();
            try {
                ImageWriter writer = ImageIO.getImageWritersByFormatName(ext).next();
                ImageWriteParam writeParam = writer.getDefaultWriteParam();
                if (writeParam.canWriteCompressed()) {
                    if (writeParam.canWriteProgressive()) {
                        writeParam.setProgressiveMode(3);
                    }
                    img = this.convertCMYK2RGB(img);
                    writeParam.setCompressionMode(2);
                    if (!fileName.endsWith("gif")) {
                        writeParam.setCompressionQuality(DEFAULT_IMAGE_COMPRESSION_VALUE);
                    }
                }
            }
            catch (Exception ex) {
                Log.Error((Object)this, (Throwable)ex);
            }
            ImageIO.write((RenderedImage)img, ext, sized);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected BufferedImage convertCMYK2RGB(BufferedImage image) throws IOException {
        BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 5);
        ColorConvertOp op = new ColorConvertOp(null);
        op.filter(image, rgbImage);
        return rgbImage;
    }

    protected BufferedImage bimgFromBytez(byte[] source) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(source);){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage != null) {
                BufferedImage bufferedImage2 = bufferedImage;
                return bufferedImage2;
            }
            throw new IllegalArgumentException("No ImageReader could read the provided data");
        }
    }

    public BufferedImage scalePreservingAspectRatioAsImage(byte[] source, int targetW, int targetH) throws IOException {
        BufferedImage bufferedImage = this.bimgFromBytez(source);
        return this.scalePreservingAspectRatioAsImage(bufferedImage, targetW, targetH);
    }

    public BufferedImage scalePreservingAspectRatioAsImage(BufferedImage bimg, int targetW, int targetH) {
        double height;
        double width = bimg.getWidth();
        Scalr.Mode mode = (double)targetW / width >= (double)targetH / (height = (double)bimg.getHeight()) ? Scalr.Mode.FIT_TO_WIDTH : Scalr.Mode.FIT_TO_HEIGHT;
        bimg = Scalr.resize((BufferedImage)bimg, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)mode, (int)targetW, (int)targetH, (BufferedImageOp[])new BufferedImageOp[0]);
        int scaledImageW = bimg.getWidth();
        int scaledImageH = bimg.getHeight();
        if (scaledImageH != targetH || scaledImageW != targetW) {
            if (scaledImageH > scaledImageW) {
                int startingW = (scaledImageW - targetW) / 2;
                int startingH = 0;
                bimg = bimg.getSubimage(startingW, startingH, targetW, targetH);
            } else {
                int startingW = (scaledImageW - targetW) / 2;
                int startingH = (scaledImageH - targetH) / 2;
                bimg = bimg.getSubimage(startingW, startingH, targetW, targetH);
            }
        }
        return bimg;
    }
}

