/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.apputil.Crypter;
import org.nustaq.kontraktor.apputil.ExposeEntry;
import org.nustaq.kontraktor.remoting.http.undertow.builder.BldFourK;

public interface FileExposerMixin<SELF extends Actor<SELF>> {
    public static final String URLPREFIX = "exposed";
    public static final ConcurrentHashMap<String, ExposeEntry> exposedDocuments = new ConcurrentHashMap();

    public static void auto(BldFourK bld, Object mixin) {
        bld.httpHandler(URLPREFIX, httpServerExchange -> {
            httpServerExchange.dispatch();
            httpServerExchange.setResponseCode(200);
            ((FileExposerMixin)mixin).handleExposedFileAccess(httpServerExchange);
        });
    }

    default public void handleExposedFileAccess(HttpServerExchange httpServerExchange) {
        try {
            String requestPath = httpServerExchange.getRequestPath();
            String[] split = requestPath.split("/");
            String docId = split[split.length - 1];
            ExposeEntry exposeEntry = this.takeFile(docId);
            httpServerExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, exposeEntry.type + "; charset=utf-8");
            httpServerExchange.getResponseSender().send(ByteBuffer.wrap(exposeEntry.getBytes()));
            this.takeFile(docId);
        }
        catch (Exception e) {
            httpServerExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html; charset=utf-8");
            try {
                httpServerExchange.getResponseSender().send(ByteBuffer.wrap("Unbekannte Resource".getBytes("UTF-8")));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @CallerSideMethod
    default public String exposeFile(File localPath, String type, Crypter cr) {
        String uid = UUID.randomUUID().toString();
        exposedDocuments.put(uid, new ExposeEntry(localPath, type).crypter(cr));
        return uid;
    }

    @CallerSideMethod
    default public ExposeEntry takeFile(String id) {
        ExposeEntry entry = exposedDocuments.get(id);
        exposedDocuments.remove(id);
        return entry;
    }
}

