/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.services;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Supplier;
import org.nustaq.kontraktor.util.Log;

public class ServiceArgs {
    public static Supplier<ServiceArgs> factory = () -> new ServiceArgs();
    @Parameter(names={"-s", "-servicereg"}, description="serviceregistry host")
    String registryHost = "localhost";
    @Parameter(names={"-sp", "-serviceregport"}, description="serviceregistry port")
    int registry = 4567;
    @Parameter(names={"-h", "-help", "-?", "--help"}, help=true, description="display help")
    boolean help;
    @Parameter(names={"-host"}, help=true, description="host address/name of this service")
    private String host = "localhost";
    @Parameter(names={"-dsPortBase"}, help=true, description="port of data shard 0. port(shard_X) = portBase + X")
    private int dataShardPortBase = 30000;
    @Parameter(names={"-nolog"}, help=true, description="log to sysout without log4j", arity=1)
    public boolean asyncLog = true;
    @Parameter(names={"-monitorhost"}, help=true, description="monitoring api host address/name of this service")
    private String monhost = "localhost";
    @Parameter(names={"-monitorport"}, help=true, description="monitoring api port of this service")
    private int monport = 1113;

    public static ServiceArgs New() {
        return factory.get();
    }

    protected ServiceArgs() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Log.Warn((Object)this, (Throwable)e);
        }
    }

    public String getMonhost() {
        return this.monhost;
    }

    public int getMonport() {
        return this.monport;
    }

    public String getRegistryHost() {
        return this.registryHost;
    }

    public int getRegistryPort() {
        return this.registry;
    }

    public int getDataShardPortBase() {
        return this.dataShardPortBase;
    }

    public boolean isHelp() {
        return this.help;
    }

    public String toString() {
        return "ServiceArgs{registryHost='" + this.registryHost + '\'' + ", registry=" + this.registry + ", help=" + this.help + ", host='" + this.host + '\'' + ", dataShardPortBase=" + this.dataShardPortBase + '}';
    }

    public String getHost() {
        return this.host;
    }

    public boolean isAsyncLog() {
        return this.asyncLog;
    }

    public static ServiceArgs parseCommandLine(String[] args, ServiceArgs options) {
        JCommander com = new JCommander();
        com.addObject((Object)options);
        try {
            com.parse(args);
        }
        catch (Exception ex) {
            System.out.println("command line error: '" + ex.getMessage() + "'");
            options.help = true;
        }
        if (options.help) {
            com.usage();
            System.exit(-1);
        }
        return options;
    }
}

