/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.services;

import java.io.File;
import java.io.Serializable;
import java.util.function.Consumer;
import org.nustaq.kontraktor.services.rlclient.DataCfg;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kson.Kson;
import org.nustaq.reallive.api.TableDescription;

public class ClusterCfg
implements Serializable {
    public static String pathname = "run/etc/clustercfg.kson";
    public static long lastTime;
    public static Consumer<ClusterCfg> clusterCfgModificationHook;
    String publicHostUrl = "http://localhost:8888";
    DataCfg dataCluster = new DataCfg();

    public static boolean isDirty() {
        return new File(pathname).lastModified() != lastTime;
    }

    public static ClusterCfg read() {
        lastTime = new File(pathname).lastModified();
        return ClusterCfg.read(pathname);
    }

    public static ClusterCfg read(String pathname) {
        Kson kson = new Kson().map(new Class[]{ClusterCfg.class, DataCfg.class, TableDescription.class});
        try {
            ClusterCfg clCfg = (ClusterCfg)kson.readObject(new File(pathname));
            if (clusterCfgModificationHook != null) {
                clusterCfgModificationHook.accept(clCfg);
            }
            String confString = kson.writeObject((Object)clCfg);
            System.out.println("run with config from " + new File(pathname).getCanonicalPath());
            return clCfg;
        }
        catch (Exception e) {
            Log.Warn(null, (String)(pathname + " not found or parse error. " + e.getClass().getSimpleName() + ":" + e.getMessage()));
            try {
                String sampleconf = kson.writeObject((Object)new ClusterCfg());
                System.out.println("Try:\n" + sampleconf);
                System.exit(1);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return new ClusterCfg();
        }
    }

    public DataCfg getDataCluster() {
        return this.dataCluster;
    }

    public ClusterCfg dataCluster(DataCfg dataCluster) {
        this.dataCluster = dataCluster;
        return this;
    }

    public static void main(String[] args) {
        ClusterCfg read = ClusterCfg.read();
        System.out.println(read);
    }
}

