/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil;

import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.annotations.CallerSideMethod;

public interface UniqueSessionIntIdMixin<SELF extends Actor<SELF>> {
    public static final AtomicInteger count = new AtomicInteger(1);
    public static final int MAX_CONC_SESSIONS = 1000000;

    default public void initUniqueSessionIntIdMixin() {
        if (this._getUnqiqueIntSessionId() == 0) {
            int id = count.incrementAndGet();
            this._setUnqiqueInSessionId(id);
            if (count.get() == 1000000) {
                count.compareAndSet(1000000, 1);
            }
        }
    }

    public SELF getActor();

    @CallerSideMethod
    default public int getIntSessionId() {
        this.initUniqueSessionIntIdMixin();
        return this._getUnqiqueIntSessionId();
    }

    @CallerSideMethod
    public int _getUnqiqueIntSessionId();

    @CallerSideMethod
    public void _setUnqiqueInSessionId(int var1);
}

