/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil;

import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.remoting.base.SessionResurrector;
import org.nustaq.kontraktor.services.rlclient.DataClient;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.Record;

public interface SessionHandlingMixin<SELF extends Actor<SELF>>
extends SessionResurrector {
    public static final String TableName = "session2user";

    @CallerSideMethod
    @Local
    public DataClient getDClient();

    @Local
    default public IPromise<Actor> reanimate(String sessionId, long remoteRefId) {
        Record rec = (Record)this.getDClient().tbl(TableName).get(sessionId).await();
        if (rec != null) {
            Log.Info((Object)this, (String)("reanimated session " + sessionId + " with data " + rec));
            return this.login(rec.getSafeString("userName"), rec.getSafeString("pwd"), null);
        }
        return new Promise(null);
    }

    public IPromise login(String var1, String var2, Callback var3);

    @Local
    default public void registerSessionData(String id, String userName, String pwd) {
        this.getDClient().tbl(TableName).update(id, new Object[]{"userName", userName, "pwd", pwd});
    }
}

