/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.apputil.LinkMapperMixin;
import org.nustaq.kontraktor.apputil.Mailer;
import org.nustaq.kontraktor.apputil.RegistrationRecord;
import org.nustaq.kontraktor.apputil.UserRecord;
import org.nustaq.kontraktor.remoting.http.undertow.builder.BldFourK;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.RLPredicate;
import org.nustaq.reallive.api.Record;
import org.nustaq.serialization.coders.Unknown;

public interface RegistrationMixin<SELF extends Actor<SELF>>
extends LinkMapperMixin<SELF> {
    public static final String UserTableName = "user";
    public static final long MAX_AGE = TimeUnit.DAYS.toMillis(3L);

    public static void auto(BldFourK bld, Object registrationMixin) {
        LinkMapperMixin.auto(bld, registrationMixin);
    }

    default public IPromise<RegistrationRecord> register(Unknown data) {
        Promise p = new Promise();
        RegistrationRecord registerform = new RegistrationRecord(data);
        registerform.creation(System.currentTimeMillis());
        registerform.name(registerform.getName().trim());
        String name = registerform.getName().trim().toLowerCase();
        this.getDClient().tbl(UserTableName).forEach((RLPredicate & Serializable)rec -> new UserRecord((Record)rec).getName().equalsIgnoreCase(name), (Callback & Serializable)(rec, err) -> {
            if (rec != null) {
                p.reject((Object)("Der Name '" + rec.get("name") + "' existiert bereits"));
            } else if (!p.isSettled()) {
                this.putRecord(registerform).then((Callback & Serializable)(r, e) -> {
                    if (r != null) {
                        HashMap<String, Object> copiedMap = RegistrationMixin.createData(data, registerform);
                        Mailer.get().sendTemplateChannelMail("registration", registerform.getEmail(), "Bitte best\u00e4tigen sie Ihre Registrierung", "mail/opt-in.html", copiedMap);
                        p.resolve((Object)registerform);
                    } else {
                        p.reject(e);
                    }
                });
            }
        });
        return p;
    }

    public static HashMap<String, Object> createData(Unknown data, RegistrationRecord registerform) {
        HashMap<String, Object> copiedMap = new HashMap<String, Object>();
        data.getFields().forEach((k, v) -> copiedMap.put((String)k, v));
        copiedMap.put("confirm-link", "links/" + registerform.getKey());
        return copiedMap;
    }

    @Override
    @CallerSideMethod
    @Local
    default public String handleLinkSuccess(String linkId, Record linkRecord) {
        if (linkRecord.getSafeString("type").equals("Registration")) {
            RegistrationRecord regRec = new RegistrationRecord(linkRecord);
            if (System.currentTimeMillis() - regRec.getCreation() > MAX_AGE) {
                return RegistrationMixin.applyTemplate(regRec, "html/registration-old.html");
            }
            Record existing = (Record)this.getDClient().tbl(UserTableName).get(regRec.getEmail().toLowerCase()).await();
            if (existing == null) {
                existing = (Record)this.getDClient().tbl(UserTableName).find((RLPredicate & Serializable)rec -> rec.getSafeString("name").equalsIgnoreCase(regRec.getName())).await();
            }
            if (existing != null) {
                return RegistrationMixin.applyTemplate(regRec, "html/registration-exists.html");
            }
            this.createUserFromRegistrationRecord(regRec);
            return RegistrationMixin.applyTemplate(regRec, "html/registration-success.html");
        }
        return RegistrationMixin.applyTemplate(null, "html/registration-fail.html");
    }

    @Override
    @CallerSideMethod
    @Local
    default public String handleLinkFailure(String linkId) {
        return RegistrationMixin.applyTemplate(null, "html/registration-fail.html");
    }

    default public IPromise<UserRecord> createUserFromRegistrationRecord(RegistrationRecord rec) {
        UserRecord u = new UserRecord(rec.getEmail().toLowerCase());
        ((UserRecord)((UserRecord)((UserRecord)((UserRecord)u.name(rec.getName())).email(rec.getEmail())).creation(System.currentTimeMillis())).pwd(rec.getPwd())).role("User");
        this.getDClient().tbl(UserTableName).setRecord(u.getRecord());
        return Actors.resolve((Object)u);
    }

    public static String applyTemplate(RegistrationRecord rec, String template) {
        try {
            Map data = rec != null ? rec.asMap() : new HashMap();
            return Mailer.applyTemplate(template, data, (k, v) -> "" + v);
        }
        catch (IOException e) {
            Log.Warn(RegistrationMixin.class, (Throwable)e);
            return "<html>internal error " + e + "</html>";
        }
    }
}

