/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nustaq.kontraktor.apputil.MailChannel;
import org.nustaq.kson.Kson;

public class MailCfg
implements Serializable {
    String user = "none";
    String password = "none";
    String smtpHost = "none";
    String smtpPort = "none";
    String smtpAuth = "none";
    String startTls = "none";
    String templateBase = "./run/templates/";
    transient Map<String, MailChannel> channelMap;
    MailChannel[] channelConf = new MailChannel[]{new MailChannel("default", "system@system.io", "System"), new MailChannel("registration", "registration@system.io", "System Registration")};

    public static MailCfg read(String file) throws Exception {
        MailCfg mailCfg = (MailCfg)new Kson().map(new Class[]{MailCfg.class, MailChannel.class}).readObject(new File(file), MailCfg.class);
        mailCfg.initChannels();
        return mailCfg;
    }

    private void initChannels() {
        this.channelMap = new HashMap<String, MailChannel>();
        for (int i = 0; i < this.channelConf.length; ++i) {
            MailChannel mailChannel = this.channelConf[i];
            this.channelMap.put(mailChannel.getSymbolicName(), mailChannel);
        }
        if (this.channelMap.get("default") == null) {
            MailChannel def = new MailChannel("default", "system@system.io", "System");
            this.channelMap.put(def.getSymbolicName(), def);
        }
    }

    public String getTemplateBase() {
        return this.templateBase;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public String getSmtpAuth() {
        return this.smtpAuth;
    }

    public String getStartTls() {
        return this.startTls;
    }

    public MailChannel getChannel(String name) {
        MailChannel mailChannel;
        if (this.channelMap == null) {
            this.initChannels();
        }
        if ((mailChannel = this.channelMap.get(name)) == null) {
            return this.channelMap.get("default");
        }
        return mailChannel;
    }

    public MailCfg user(String user) {
        this.user = user;
        return this;
    }

    public MailCfg password(String password) {
        this.password = password;
        return this;
    }

    public MailCfg smtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
        return this;
    }

    public MailCfg smtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
        return this;
    }

    public MailCfg smtpAuth(String smtpAuth) {
        this.smtpAuth = smtpAuth;
        return this;
    }

    public MailCfg startTls(String startTls) {
        this.startTls = startTls;
        return this;
    }
}

