/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.services.rlclient;

import java.io.File;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ConnectableActor;
import org.nustaq.kontraktor.remoting.tcp.TCPConnectable;
import org.nustaq.kontraktor.services.ServiceActor;
import org.nustaq.kontraktor.services.ServiceArgs;
import org.nustaq.kontraktor.services.ServiceDescription;
import org.nustaq.kontraktor.services.ServiceRegistry;
import org.nustaq.kontraktor.services.rlclient.DataCfg;
import org.nustaq.kontraktor.services.rlclient.DataShardArgs;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.impl.tablespace.TableSpaceActor;

public class DataShard
extends ServiceActor<DataShard> {
    public static final String DATA_SHARD_NAME = "DataShard";
    TableSpaceActor tableSpace;

    @Override
    public IPromise init(ConnectableActor registryConnectable, ServiceArgs options, boolean auto) {
        Promise p = new Promise();
        try {
            super.init(registryConnectable, options, false).then((arg_0, arg_1) -> this.lambda$init$2252ec85$1((IPromise)p, arg_0, arg_1));
        }
        catch (Throwable t) {
            p.reject((Object)t);
        }
        return p;
    }

    @Override
    protected int getPort() {
        return this.cmdline.getDataShardPortBase() + this.getCmdline().getShardNo();
    }

    protected void initTableSpace() {
        DataCfg dataCfg = this.config.getDataCluster();
        this.tableSpace = (TableSpaceActor)Actors.AsActor(TableSpaceActor.class);
        String dir = dataCfg.getDataDir()[this.getCmdline().getShardNo()];
        new File(dir).mkdirs();
        this.tableSpace.setBaseDataDir(dir);
        this.tableSpace.init();
        this.tableSpace.ping().await();
        Log.Info((Object)((Object)this), (String)("init tablespace in " + dataCfg.getDataDir()[this.getCmdline().getShardNo()] + " shard " + this.getCmdline().getShardNo() + " of " + dataCfg.getNumberOfShards()));
    }

    public IPromise<TableSpaceActor> getTableSpace() {
        return DataShard.resolve((Object)this.tableSpace);
    }

    @Override
    protected boolean needsDataCluster() {
        return false;
    }

    @Override
    protected String[] getRequiredServiceNames() {
        return new String[0];
    }

    @Override
    protected ServiceDescription createServiceDescription() {
        return new ServiceDescription(DATA_SHARD_NAME + this.getCmdline().getShardNo()).connectable((ConnectableActor)new TCPConnectable(DataShard.class, this.cmdline.getHost(), this.cmdline.getDataShardPortBase() + this.getCmdline().getShardNo()));
    }

    @Override
    protected DataShardArgs getCmdline() {
        return (DataShardArgs)this.cmdline;
    }

    public static void main(String[] args) {
        DataShard.start(args);
    }

    public static DataShard start(String[] args) {
        DataShard ds = (DataShard)Actors.AsActor(DataShard.class, (int)256000);
        DataShardArgs options = (DataShardArgs)ServiceRegistry.parseCommandLine(args, new DataShardArgs());
        ds.init((ConnectableActor)new TCPConnectable(ServiceRegistry.class, options.getRegistryHost(), options.getRegistryPort()), options, true);
        Log.Info(((Object)((Object)ds)).getClass(), (String)"Init finished");
        return ds;
    }

    private /* synthetic */ void lambda$init$2252ec85$1(IPromise p, Object r, Object e) {
        try {
            this.initTableSpace();
            this.registerSelf();
            p.resolve();
        }
        catch (Exception ex) {
            Log.Error((Object)((Object)this), (Throwable)ex);
        }
    }
}

