/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.services;

import java.io.Serializable;
import java.util.UUID;
import org.nustaq.kontraktor.remoting.base.ConnectableActor;

public class ServiceDescription
implements Serializable {
    String name;
    String description;
    String uniqueKey = UUID.randomUUID().toString();
    ConnectableActor connectable;
    transient long lastPing;
    long timeout = 100000L;

    public ServiceDescription(String name) {
        this.name = name;
    }

    public ServiceDescription description(String description) {
        this.description = description;
        return this;
    }

    public ServiceDescription connectable(ConnectableActor connectable) {
        this.connectable = connectable;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ServiceDescription timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public ConnectableActor getConnectable() {
        return this.connectable;
    }

    public ServiceDescription unqiqueKey(String unqiqueKey) {
        this.uniqueKey = unqiqueKey;
        return this;
    }

    public void receiveHeartbeat() {
        this.lastPing = System.currentTimeMillis();
    }

    public long getLastPing() {
        return this.lastPing;
    }

    public boolean hasTimedOut() {
        return System.currentTimeMillis() - this.lastPing > this.timeout;
    }

    public String toString() {
        return "ServiceDescription{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", uniqueKey='" + this.uniqueKey + '\'' + ", connectable=" + this.connectable + ", lastPing=" + this.lastPing + ", timeout=" + this.timeout + '}';
    }
}

