/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.apputil;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.apputil.MailCfg;
import org.nustaq.kontraktor.util.Log;

public class Mailer
extends Actor<Mailer> {
    static Mailer singleton;
    MailCfg settings;

    public static void initSingleton(MailCfg settings) {
        Mailer m = (Mailer)Mailer.AsActor(Mailer.class);
        m.init(settings);
        singleton = m;
    }

    public static Mailer get() {
        return singleton;
    }

    public void init(MailCfg conf) {
        this.updateSettings(conf);
    }

    public void updateSettings(MailCfg conf) {
        this.settings = conf;
    }

    public IPromise<Boolean> sendMail(String receiver, String subject, String content, String displayName) {
        if (receiver == null || !receiver.contains("@")) {
            return new Promise((Object)false, (Object)("Not a valid email address: " + receiver));
        }
        try {
            Properties props = new Properties();
            props.put("mail.smtp.auth", this.settings.getSmtpAuth());
            props.put("mail.smtp.starttls.enable", this.settings.getStartTls());
            props.put("mail.smtp.host", this.settings.getSmtpHost());
            props.put("mail.smtp.port", this.settings.getSmtpPort());
            Session session = Session.getInstance((Properties)props);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)(displayName == null ? new InternetAddress("support@juptr.io") : new InternetAddress("support@juptr.io", displayName)));
            message.setSubject(subject);
            message.setText(content, "utf-8", "html");
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(receiver, false));
            message.setSentDate(new Date());
            Transport.send((Message)message, (String)this.settings.getUser(), (String)this.settings.getPassword());
            Log.Info((Object)((Object)this), (String)("definitely sent mail to " + receiver + " subject:" + subject));
            return new Promise((Object)true);
        }
        catch (Exception e) {
            Log.Warn((Object)((Object)this), (Throwable)e);
            return new Promise((Object)false, (Object)e);
        }
    }
}

